/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import org.jetbrains.annotations.Nullable;

public class WoodVariantRegistry
extends VariantRegistryBase<WoodVariant> {
    public static final WoodVariant OAK = new WoodVariant(new ResourceLocation("oak"), Blocks.f_50705_, Blocks.f_49999_, Boat.Type.OAK);
    public static final WoodVariantRegistry INSTANCE = new WoodVariantRegistry();

    public static Collection<String> getNamespaces() {
        return WoodVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<WoodVariant> getVariants() {
        return Collections.unmodifiableCollection(WoodVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static WoodVariant getVariant(ResourceLocation name) {
        return WoodVariantRegistry.INSTANCE.variants.getOrDefault(name, OAK);
    }

    public static Optional<WoodVariant> getOptionalVariant(ResourceLocation name) {
        return WoodVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((WoodVariant)WoodVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Nullable
    public static WoodVariant getVariantFromVanillaWoodType(Boat.Type type) {
        for (WoodVariant woodVariant : WoodVariantRegistry.INSTANCE.variants.values()) {
            if (woodVariant.getVanillaWoodType() != type) continue;
            return woodVariant;
        }
        return null;
    }

    @Override
    public Optional<WoodVariant> getVariantFromBlock(Block baseBlock, ResourceLocation blockId) {
        BlockState state;
        String name = null;
        String path = blockId.m_135815_();
        if (blockId.m_135827_().equals("tfc")) {
            Optional log;
            if (path.contains("wood/planks/") && (log = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(blockId.m_135827_(), path.replace("planks", "log")))).isPresent()) {
                ResourceLocation id = new ResourceLocation(blockId.m_135827_(), path.replace("wood/planks/", ""));
                return Optional.of(new WoodVariant(id, baseBlock, (Block)log.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_planks")) {
            name = path.substring(0, path.length() - "_planks".length());
        } else if (path.startsWith("planks_")) {
            name = path.substring("planks_".length());
        } else if (path.endsWith("_plank")) {
            name = path.substring(0, path.length() - "_plank".length());
        } else if (path.startsWith("plank_")) {
            name = path.substring("plank_".length());
        }
        String namespace = blockId.m_135827_();
        if (!(namespace.equals("cozy_home") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("terrestria") && path.contains("sakura") || namespace.equals("betternether") && path.contains("nether_mushroom") || namespace.equals("chipped") || namespace.equals("regions_unexplored") && path.contains("alpha") || namespace.equals("modernlife") || namespace.equals("excessive_building") || (state = baseBlock.m_49966_()).m_61147_().size() > 2 || baseBlock instanceof SlabBlock || name.contains("slab") || baseBlock instanceof BasePressurePlateBlock || name.contains("pressure_plate"))) {
            SoundType soundGroup = state.m_60827_();
            NoteBlockInstrument instrument = state.m_280603_();
            if (soundGroup == SoundType.f_243772_ || soundGroup == SoundType.f_271497_ || soundGroup == SoundType.f_56736_ || soundGroup == SoundType.f_244244_ || instrument == NoteBlockInstrument.BASS) {
                name = name.replace("/", "_");
                ResourceLocation id = new ResourceLocation(blockId.m_135827_(), name);
                Block logBlock = WoodVariantRegistry.findLog(id);
                if (logBlock != null) {
                    return Optional.of(new WoodVariant(id, baseBlock, logBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public WoodVariant getDefaultType() {
        return OAK;
    }

    @Override
    public Class<WoodVariant> getType() {
        return WoodVariant.class;
    }

    @Nullable
    private static Block findLog(ResourceLocation id) {
        ResourceLocation[] test = new ResourceLocation[]{new ResourceLocation(id.m_135827_(), id.m_135815_() + "_log"), new ResourceLocation(id.m_135827_(), "log_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), id.m_135815_() + "log"), new ResourceLocation(id.m_135815_() + "_log"), new ResourceLocation("log_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "log"), new ResourceLocation(id.m_135827_(), id.m_135815_() + "_stem"), new ResourceLocation(id.m_135827_(), "stem_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stem"), new ResourceLocation("stem_" + id.m_135815_()), new ResourceLocation(id.m_135827_(), "stalk_" + id.m_135815_()), new ResourceLocation(id.m_135815_() + "_stalk"), new ResourceLocation("stalk_" + id.m_135815_())};
        Block temp = null;
        for (ResourceLocation r : test) {
            if (!BuiltInRegistries.f_256975_.m_7804_(r)) continue;
            temp = (Block)BuiltInRegistries.f_256975_.m_7745_(r);
            break;
        }
        return temp;
    }
}

