/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.runtime.assets;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.BasicChairBlock;
import com.unlikepaladin.pfm.blocks.BasicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskBlock;
import com.unlikepaladin.pfm.blocks.BasicDeskCabinetBlock;
import com.unlikepaladin.pfm.blocks.BasicTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicBedBlock;
import com.unlikepaladin.pfm.blocks.ClassicChairBlock;
import com.unlikepaladin.pfm.blocks.ClassicCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ClassicNightstandBlock;
import com.unlikepaladin.pfm.blocks.ClassicStoolBlock;
import com.unlikepaladin.pfm.blocks.ClassicTableBlock;
import com.unlikepaladin.pfm.blocks.DinnerChairBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.KitchenCabinetBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenCounterOvenBlock;
import com.unlikepaladin.pfm.blocks.KitchenDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenSinkBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallCounterBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerBlock;
import com.unlikepaladin.pfm.blocks.KitchenWallDrawerSmallBlock;
import com.unlikepaladin.pfm.blocks.LogStoolBlock;
import com.unlikepaladin.pfm.blocks.LogTableBlock;
import com.unlikepaladin.pfm.blocks.ModernChairBlock;
import com.unlikepaladin.pfm.blocks.ModernCoffeeTableBlock;
import com.unlikepaladin.pfm.blocks.ModernDinnerTableBlock;
import com.unlikepaladin.pfm.blocks.ModernStoolBlock;
import com.unlikepaladin.pfm.blocks.RawLogTableBlock;
import com.unlikepaladin.pfm.blocks.SimpleBedBlock;
import com.unlikepaladin.pfm.blocks.SimpleBunkLadderBlock;
import com.unlikepaladin.pfm.blocks.SimpleStoolBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariant;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import com.unlikepaladin.pfm.mixin.PFMLanguageManagerAccessor;
import com.unlikepaladin.pfm.registry.QuadFunc;
import com.unlikepaladin.pfm.runtime.PFMGenerator;
import com.unlikepaladin.pfm.runtime.PFMProvider;
import com.unlikepaladin.pfm.runtime.PFMRuntimeResources;
import com.unlikepaladin.pfm.utilities.PFMFileUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.metadata.language.LanguageMetadataSection;
import net.minecraft.locale.Language;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class PFMLangProvider
extends PFMProvider {
    private Map<String, LanguageInfo> languageDefs = ImmutableMap.of((Object)"en_us", (Object)PFMLanguageManagerAccessor.getEnglish_Us());
    private static volatile Language language = Language.m_128107_();
    private final HashMap<VariantBase<?>, String> translationMap = new HashMap();

    public PFMLangProvider(PFMGenerator parent) {
        super(parent, "PFM Lang");
        parent.setProgress("Generating Language Resources");
    }

    @Override
    public void run() {
        this.startProviderRun();
        try (PFMResourceManager resourceManager = new PFMResourceManager(PackType.CLIENT_RESOURCES, PFMRuntimeResources.RESOURCE_PACK_LIST);){
            this.loadLanguages(resourceManager);
            resourceManager.close();
        }
        catch (Exception e) {
            this.getParent().getLogger().info((Object)e);
        }
        try (BufferedWriter writer = IOUtils.buffer((Writer)new FileWriter(new File(PFMRuntimeResources.createDirIfNeeded(this.getParent().getOrCreateSubDirectory("assets/pfm").resolve("lang")).toFile(), "en_us.json")));){
            writer.write("{\n");
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMap(), writer, "block.pfm.basic_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicChairBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.basic_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMap(), writer, "block.pfm.dinner_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(DinnerChairBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.dinner_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMap(), writer, "block.pfm.classic_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicChairBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.classic_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMap(), writer, "block.pfm.modern_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernChairBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.modern_chair", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_classic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_classic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_log", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(LogTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_log", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_log", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(RawLogTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_log", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_dinner", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(DinnerTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_dinner", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.table_modern_dinner", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernDinnerTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.table_modern_dinner", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariantToBlockMap(), writer, "block.pfm.log_stool", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(LogStoolBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.log_stool", this::logTableFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMap(), writer, "block.pfm.simple_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleStoolBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.simple_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMap(), writer, "block.pfm.classic_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicStoolBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.classic_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMap(), writer, "block.pfm.modern_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernStoolBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.modern_stool", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMap(), writer, "block.pfm.classic_nightstand", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicNightstandBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.classic_nightstand", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForBedMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList(), writer, "block.pfm.simple_bed", this::bedFurnitureTranslation);
            this.generateTranslationForBedMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBedBlock.class).getVariantToBlockMapList(), writer, "block.pfm.simple_bed", this::bedFurnitureTranslation);
            this.generateTranslationForBedMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariantToBlockMapList(), writer, "block.pfm.classic_bed", this::bedFurnitureTranslation);
            this.generateTranslationForBedMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicBedBlock.class).getVariantToBlockMapList(), writer, "block.pfm.classic_bed", this::bedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariantToBlockMap(), writer, "block.pfm.simple_bunk_ladder", this::simpleFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(SimpleBunkLadderBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.simple_bunk_ladder", this::simpleFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_counter", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_counter", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenDrawerBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_cabinet", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCabinetBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_cabinet", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_sink", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenSinkBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_sink", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_counter_oven", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenCounterOvenBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_counter_oven", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_wall_counter", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallCounterBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_wall_counter", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_wall_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_wall_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMap(), writer, "block.pfm.kitchen_wall_small_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(KitchenWallDrawerSmallBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.kitchen_wall_small_drawer", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForLampBlock(writer);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.coffee_table_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.coffee_table_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.coffee_table_modern", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ModernCoffeeTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.coffee_table_modern", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMap(), writer, "block.pfm.coffee_table_classic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(ClassicCoffeeTableBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.coffee_table_classic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariantToBlockMap(), writer, "block.pfm.desk_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.desk_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariantToBlockMap(), writer, "block.pfm.desk_cabinet_basic", this::simpleStrippedFurnitureTranslation);
            this.generateTranslationForVariantBlockMap(PaladinFurnitureMod.furnitureEntryMap.get(BasicDeskCabinetBlock.class).getVariantToBlockMapNonBase(), writer, "block.pfm.desk_cabinet_basic", this::simpleStrippedFurnitureTranslation);
            writer.write("    \"pfm.dummy.entry\": \"dummy entry\"\n");
            writer.write("}");
        }
        catch (IOException e) {
            this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
            e.printStackTrace();
        }
        this.endProviderRun();
    }

    public String simpleStrippedFurnitureTranslation(Block block, String furnitureKey, String strippedKey, String translatedVariantName) {
        return this.translate(furnitureKey, strippedKey, translatedVariantName);
    }

    public String logTableFurnitureTranslation(Block block, String furnitureKey, String strippedKey, String translatedVariantName) {
        String rawFix;
        String string = rawFix = block.m_7705_().contains("raw") ? this.translate("block.type.raw", new Object[0]) : "";
        String extraLogKey = block.m_7705_().contains("stem") ? this.translate("block.type.stem", new Object[0]) : (block.m_7705_().contains("natural") ? this.translate("block.type.natural", new Object[0]) : this.translate("block.type.log", new Object[0]));
        return this.translate(furnitureKey, rawFix + (rawFix.isBlank() ? "" : " ") + strippedKey, translatedVariantName, extraLogKey);
    }

    public String simpleFurnitureTranslation(Block block, String furnitureKey, String strippedKey, String translatedVariantName) {
        return this.translate(furnitureKey, translatedVariantName);
    }

    public String bedFurnitureTranslation(Block block, String furnitureKey, String strippedKey, String translatedVariantName) {
        String color = block instanceof SimpleBedBlock ? this.translate("color.minecraft." + ((SimpleBedBlock)block).getPFMColor().m_7912_(), new Object[0]) : "";
        return this.translate(furnitureKey, translatedVariantName, color);
    }

    private Map<String, LanguageInfo> loadAvailableLanguages(Stream<PackResources> packs) {
        HashMap map = Maps.newHashMap();
        packs.forEach(pack -> {
            try {
                List<PackResources> subPacks = PFMFileUtil.getSubPacks(pack);
                for (PackResources subPack : subPacks) {
                    LanguageMetadataSection languageResourceMetadata = (LanguageMetadataSection)subPack.m_5550_((MetadataSectionSerializer)LanguageMetadataSection.f_263724_);
                    if (languageResourceMetadata == null) continue;
                    languageResourceMetadata.f_119097_().forEach(map::putIfAbsent);
                }
            }
            catch (IOException | RuntimeException exception) {
                this.getParent().getLogger().warn("Unable to parse language metadata section of resourcepack: {}", (Object)pack.m_5542_(), (Object)exception);
            }
        });
        return ImmutableMap.copyOf((Map)map);
    }

    public void loadLanguages(ResourceManager manager) {
        LanguageInfo languageDefinition;
        this.languageDefs = this.loadAvailableLanguages(manager.m_7536_());
        ArrayList<String> list = new ArrayList<String>(2);
        boolean bl = true;
        list.add("en_us");
        LanguageInfo enUSDefinition = this.languageDefs.getOrDefault("en_us", PFMLanguageManagerAccessor.getEnglish_Us());
        String selectedDef = ((PFMLanguageManagerAccessor)Minecraft.m_91087_().m_91102_()).getCurrentLanguageCode();
        if (!selectedDef.equals("en_us") && (languageDefinition = this.languageDefs.getOrDefault(selectedDef, enUSDefinition)) != null) {
            list.add(selectedDef);
            bl = languageDefinition.f_118946_();
        }
        ClientLanguage translationStorage = ClientLanguage.m_264420_((ResourceManager)manager, list, (boolean)bl);
        language = translationStorage;
        Language.m_128114_((Language)translationStorage);
    }

    public String translate(String key, Object ... args) {
        String string = language.m_6834_(key);
        try {
            return String.format(string, args);
        }
        catch (IllegalFormatException illegalFormatException) {
            this.getParent().getLogger().error("Format error: " + string + "\n" + String.valueOf(illegalFormatException));
            return "Format error: " + string;
        }
    }

    public void generateTranslationForLampBlock(BufferedWriter writer) {
        block2: for (WoodVariant variant : WoodVariantRegistry.getVariants()) {
            int i = 0;
            for (DyeColor color : DyeColor.values()) {
                if (i > 15) continue block2;
                try {
                    String translatedVariantName = this.getTranslatedVariantName(variant);
                    String translatedColor = this.translate("color.minecraft." + color.m_41065_(), new Object[0]);
                    String translatedFurnitureName = StringUtils.normalizeSpace((String)this.translate("block.pfm.basic_lamp", translatedColor, translatedVariantName));
                    writer.write(String.format("    \"%1$s\": \"%2$s\",", String.format("block.pfm.basic_%s_%s_lamp", color.m_7912_(), variant.m_7912_()), translatedFurnitureName));
                    writer.write("\n");
                }
                catch (IOException e) {
                    this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
                    throw new RuntimeException(e);
                }
                ++i;
            }
        }
    }

    public String getTranslatedVariantName(VariantBase<?> variant) {
        if (this.translationMap.containsKey(variant)) {
            return this.translationMap.get(variant);
        }
        AtomicReference<String> variantName = new AtomicReference<String>(this.translate(variant.getSecondaryBlock().m_7705_(), new Object[0]));
        String baseBlockName = this.translate(variant.getBaseBlock().m_7705_(), new Object[0]);
        List<String> common = PFMLangProvider.findCommonWords(variantName.get(), baseBlockName);
        variantName.set("");
        if (variant == WoodVariantRegistry.getVariantFromVanillaWoodType(Boat.Type.BAMBOO)) {
            variantName.set(variantName.get().replace("Block of", ""));
        }
        variantName.set(String.join((CharSequence)" ", common));
        this.translationMap.put(variant, variantName.get());
        return variantName.get();
    }

    public void generateTranslationForBedMap(HashMap<VariantBase<?>, ? extends Set<?>> variantBaseHashMap, BufferedWriter writer, String furnitureKey, QuadFunc<Block, String, String, String, String> blockStringStringStringStringQuadFunc) {
        variantBaseHashMap.forEach((variant, list) -> list.forEach(block1 -> {
            Block block = (Block)block1;
            if (variant instanceof WoodVariant) {
                String translatedVariantName = this.getTranslatedVariantName((VariantBase<?>)variant);
                String strippedKey = block.m_7705_().contains("stripped") ? this.translate("block.type.stripped", new Object[0]) : "";
                String translatedFurnitureName = StringUtils.normalizeSpace((String)((String)blockStringStringStringStringQuadFunc.apply(block, furnitureKey, strippedKey, translatedVariantName)));
                try {
                    writer.write(String.format("    \"%1$s\": \"%2$s\",", block.m_7705_(), translatedFurnitureName));
                    writer.write("\n");
                }
                catch (IOException e) {
                    this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
                    throw new RuntimeException(e);
                }
            }
        }));
    }

    public void generateTranslationForVariantBlockMap(Map<VariantBase<?>, ? extends Block> variantBaseHashMap, BufferedWriter writer, String furnitureKey, QuadFunc<Block, String, String, String, String> blockStringStringStringStringQuadFunc) {
        variantBaseHashMap.forEach((variant, block) -> {
            if (variant instanceof WoodVariant) {
                String translatedVariantName = this.getTranslatedVariantName((VariantBase<?>)variant);
                String strippedKey = block.m_7705_().contains("stripped") ? this.translate("block.type.stripped", new Object[0]) : "";
                String translatedFurnitureName = StringUtils.normalizeSpace((String)((String)blockStringStringStringStringQuadFunc.apply((Block)block, furnitureKey, strippedKey, translatedVariantName)));
                try {
                    writer.write(String.format("    \"%1$s\": \"%2$s\",", block.m_7705_(), translatedFurnitureName));
                    writer.write("\n");
                }
                catch (IOException e) {
                    this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
                    throw new RuntimeException(e);
                }
            }
            String key = "block.pfm.variant." + variant.getIdentifier().m_135815_();
            String translatedVariantName = this.translate(key, new Object[0]);
            if (translatedVariantName.equals(key) || !variant.isVanilla()) {
                translatedVariantName = this.getTranslatedVariantName((VariantBase<?>)variant);
            }
            String translatedFurnitureName = StringUtils.normalizeSpace((String)((String)blockStringStringStringStringQuadFunc.apply((Block)block, furnitureKey, "", translatedVariantName)));
            try {
                writer.write(String.format("    \"%1$s\": \"%2$s\",", block.m_7705_(), translatedFurnitureName));
                writer.write("\n");
            }
            catch (IOException e) {
                this.getParent().getLogger().error("Writer exception: " + String.valueOf(e));
                throw new RuntimeException(e);
            }
        });
    }

    public static List<String> findCommonWords(String input1, String input2) {
        String[] words1 = input1.trim().split("\\s+");
        String[] words2 = input2.trim().split("\\s+");
        ArrayList<String> list1 = new ArrayList<String>(Arrays.asList(words1));
        List<String> list2 = Arrays.asList(words2);
        list1.retainAll(list2);
        return list1;
    }

    private static final class PFMResourceManager
    implements ResourceManager,
    AutoCloseable {
        private CloseableResourceManager activeManager;
        private final PackType type;

        public PFMResourceManager(PackType type, List<PackResources> packs) {
            this.type = type;
            this.activeManager = new MultiPackResourceManager(type, packs);
        }

        @Override
        public void close() {
            this.activeManager.close();
        }

        public Optional<Resource> m_213713_(ResourceLocation identifier) {
            return this.activeManager.m_213713_(identifier);
        }

        public Set<String> m_7187_() {
            return this.activeManager.m_7187_();
        }

        public List<Resource> m_213829_(ResourceLocation id) {
            return this.activeManager.m_213829_(id);
        }

        public Map<ResourceLocation, List<Resource>> m_214160_(String startingPath, Predicate<ResourceLocation> allowedPathPredicate) {
            return this.activeManager.m_214160_(startingPath, allowedPathPredicate);
        }

        public Map<ResourceLocation, Resource> m_214159_(String startingPath, Predicate<ResourceLocation> pathPredicate) {
            return this.activeManager.m_214159_(startingPath, pathPredicate);
        }

        public Stream<PackResources> m_7536_() {
            return this.activeManager.m_7536_();
        }
    }
}

