/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.config;

import com.jaquadro.minecraft.storagedrawers.ModServices;
import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ConversionRegistry {
    public static final ConversionRegistry INSTANCE = new ConversionRegistry();
    private Set<TagKey<Item>> tagWhitelist = new HashSet<TagKey<Item>>();
    private Set<TagKey<Item>> tagBlacklist = new HashSet<TagKey<Item>>();
    private List<Set<ResourceLocation>> equivGroups = new ArrayList<Set<ResourceLocation>>();

    public void initialize() {
        ModCommonConfig.INSTANCE.onLoad(() -> {
            ((List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.tagWhitelist.get()).forEach(this::addWhitelist);
            ((List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.tagBlacklist.get()).forEach(this::addBlacklist);
            List oreTypes = (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.oreTypes.get();
            List oreMats = (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.oreMaterials.get();
            if (!oreTypes.isEmpty() && !oreMats.isEmpty() && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
                ModServices.log.info("Adding ore conversions for types: " + oreTypes.stream().collect(Collectors.joining(", ")));
                ModServices.log.info("Adding ore conversions for materials: " + oreMats.stream().collect(Collectors.joining(", ")));
            }
            for (String oreType : oreTypes) {
                for (String oreMat : oreMats) {
                    this.addWhitelist(oreType + "/" + oreMat, false);
                }
            }
            for (String entry : (List)ModCommonConfig.INSTANCE.UPGRADES.conversionUpgrade.itemEquivGroups.get()) {
                this.addEquivGroup(entry);
            }
        });
    }

    public boolean addBlacklist(String entry) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addBlacklist(parts[0], parts[1]);
    }

    public boolean addBlacklist(String namespace, String path) {
        return this.addBlacklist(new ResourceLocation(namespace, path));
    }

    public boolean addBlacklist(ResourceLocation entry) {
        if (entry == null) {
            return false;
        }
        this.tagBlacklist.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry));
        if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New conversion denied tag " + entry);
        }
        return true;
    }

    public boolean addWhitelist(String entry) {
        return this.addWhitelist(entry, true);
    }

    public boolean addWhitelist(String entry, boolean log) {
        String[] parts = entry.split(":");
        if (parts.length != 2) {
            return false;
        }
        return this.addWhitelist(parts[0], parts[1], log);
    }

    public boolean addWhitelist(String namespace, String path, boolean log) {
        return this.addWhitelist(new ResourceLocation(namespace, path), log);
    }

    public boolean addWhitelist(ResourceLocation entry, boolean log) {
        if (entry == null) {
            return false;
        }
        this.tagWhitelist.add((TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)entry));
        if (log && ((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
            ModServices.log.info("New conversion allowed tag " + entry);
        }
        return true;
    }

    public void addEquivGroup(String entry) {
        String[] items = entry.split(";\\s*");
        HashSet<ResourceLocation> group = new HashSet<ResourceLocation>();
        for (String item : items) {
            String[] parts = item.split(":");
            if (parts.length != 2) continue;
            ResourceLocation key = new ResourceLocation(parts[0], parts[1]);
            group.add(key);
        }
        if (group.size() > 1) {
            this.equivGroups.add(group);
            if (((Boolean)ModCommonConfig.INSTANCE.GENERAL.logStartupActivity.get()).booleanValue()) {
                ModServices.log.info("New conversion equivalence rule " + entry);
            }
        }
    }

    public boolean itemsShareEquivGroup(Item item1, Item item2) {
        ResourceLocation key1 = BuiltInRegistries.f_257033_.m_7981_((Object)item1);
        ResourceLocation key2 = BuiltInRegistries.f_257033_.m_7981_((Object)item2);
        for (Set<ResourceLocation> group : this.equivGroups) {
            if (!group.contains(key1) || !group.contains(key2)) continue;
            return true;
        }
        return false;
    }

    public List<ItemStack> getEquivItems(Item item) {
        ResourceLocation key = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Set<ResourceLocation> group : this.equivGroups) {
            if (!group.contains(key)) continue;
            for (ResourceLocation entry : group) {
                Item other = (Item)BuiltInRegistries.f_257033_.m_7745_(entry);
                items.add(new ItemStack((ItemLike)other));
            }
        }
        return items;
    }

    public boolean isEntryValid(TagKey<Item> entry) {
        if (this.tagBlacklist.contains(entry)) {
            return false;
        }
        return this.tagWhitelist.contains(entry);
    }
}

