/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core.recipe;

import com.jaquadro.minecraft.storagedrawers.config.ModCommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.ModSecurity;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import java.util.ArrayList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PersonalKeyRecipe
extends CustomRecipe {
    public PersonalKeyRecipe(ResourceLocation name, CraftingBookCategory cat) {
        super(name, cat);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        ItemStack pkey = this.findPersonalKey(inv);
        return !pkey.m_41619_();
    }

    private ItemStack findPersonalKey(CraftingContainer craftingInput) {
        ItemStack pkey = ItemStack.f_41583_;
        for (int i = 0; i < craftingInput.m_6643_(); ++i) {
            ItemPersonalKey pitem;
            ItemStack item = craftingInput.m_8020_(i);
            if (item == ItemStack.f_41583_) continue;
            if (!pkey.m_41619_()) {
                return ItemStack.f_41583_;
            }
            Item item2 = item.m_41720_();
            if (item2 instanceof ItemPersonalKey && this.checkPersonalKey(pitem = (ItemPersonalKey)item2)) {
                pkey = item;
                continue;
            }
            return ItemStack.f_41583_;
        }
        return pkey;
    }

    private boolean checkPersonalKey(ItemPersonalKey item) {
        String provider = item.getSecurityProviderKey();
        if (provider == null) {
            provider = "default";
        }
        if (provider.equals("default")) {
            return true;
        }
        return provider.equals("ftb") && this.ftbEnabled();
    }

    private boolean ftbEnabled() {
        return ModSecurity.registry.getProvider("ftb") != null && (Boolean)ModCommonConfig.INSTANCE.INTEGRATION.ftbTeams.enableCycleRecipe.get() != false;
    }

    public ItemStack assemble(CraftingContainer inv, RegistryAccess registries) {
        int index;
        ItemStack pkey = this.findPersonalKey(inv);
        ArrayList<Item> cycle = new ArrayList<Item>();
        cycle.add((Item)ModItems.PERSONAL_KEY.get());
        if (this.ftbEnabled()) {
            cycle.add((Item)ModItems.PERSONAL_KEY_FTB.get());
        }
        if ((index = cycle.indexOf(pkey.m_41720_())) == -1) {
            return ItemStack.f_41583_;
        }
        if (++index >= cycle.size()) {
            index = 0;
        }
        return new ItemStack((ItemLike)cycle.get(index), 1);
    }

    public boolean m_8004_(int i, int i1) {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.PERSONAL_KEY_RECIPE_SERIALIZER.get();
    }
}

