/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.jaquadro.minecraft.storagedrawers.util.WorldUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemKey
extends Item {
    private final Multimap<Attribute, AttributeModifier> modifiers;

    public ItemKey(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
    }

    public boolean m_6777_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player) {
        return !player.m_7500_();
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        ComponentUtil.appendSplitDescription(tooltip, this);
        if (!this.isEnabled()) {
            tooltip.add((Component)Component.m_237115_((String)"itemConfig.storagedrawers.disabled_tool").m_130940_(ChatFormatting.YELLOW));
        }
    }

    @NotNull
    public Component m_41466_() {
        return this.isEnabled() ? Component.m_237115_((String)(this.m_5524_() + ".desc")) : Component.m_237119_();
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (!this.isEnabled()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = WorldUtils.getBlockEntity((BlockGetter)context.m_43725_(), context.m_8083_(), BlockEntity.class);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        IDrawerAttributes attrs = Capabilities.DRAWER_ATTRIBUTES.getCapability(blockEntity.m_58904_(), blockEntity.m_58899_());
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (!(attrs instanceof IDrawerAttributesModifiable)) {
            return InteractionResult.PASS;
        }
        this.handleDrawerAttributes((IDrawerAttributesModifiable)attrs);
        if (context.m_43723_() != null) {
            context.m_43723_().m_36335_().m_41524_((Item)this, 5);
        }
        return InteractionResult.SUCCESS;
    }

    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
    }

    public boolean isEnabled() {
        return true;
    }
}

