/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.util.EntityRenderingUtil;
import com.github.alexthe666.rats.server.items.upgrades.MobFilterUpgradeItem;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateMobFilterPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class MobFilterScreen
extends Screen {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats", "textures/gui/container/mob_filter.png");
    private static final ResourceLocation TEXTURE_BACKDROP = new ResourceLocation("rats", "textures/gui/container/mob_filter_backdrop.png");
    private static final int SCROLL_X_START = 218;
    private static final int SCROLL_Y_START = 21;
    private static final int MAX_MOB_BUTTONS = 5;
    private final int imageWidth = 240;
    private final int imageHeight = 124;
    protected int leftPos;
    protected int topPos;
    private final InteractionHand hand;
    private boolean isWhitelist;
    private final List<String> selectedMobs;
    @Nullable
    private ResourceLocation hoveredEntityName;
    private int startIndex;
    private final List<Pair<String, Component>> allMobs;
    private final List<Pair<String, Component>> filteredMobs = new ArrayList<Pair<String, Component>>();
    private CheckBox whitelistSelected;
    private CheckBox selectedMobsShown;
    private EditBox searchBar;
    private float scrollOffs;
    private boolean scrolling;
    private final Set<TagKey<EntityType<?>>> visibleTags = new HashSet();

    public MobFilterScreen(InteractionHand hand) {
        super((Component)Component.m_237115_((String)"gui.rats.mob_filter"));
        this.allMobs = RatsMod.getCachedMobList((Level)Minecraft.m_91087_().f_91073_);
        this.hand = hand;
        this.isWhitelist = MobFilterUpgradeItem.isWhitelist(Minecraft.m_91087_().f_91074_.m_21120_(hand));
        this.selectedMobs = MobFilterUpgradeItem.getSelectedMobs(Minecraft.m_91087_().f_91074_.m_21120_(hand));
    }

    protected void m_7856_() {
        this.filteredMobs.clear();
        this.filteredMobs.addAll(this.allMobs);
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = (this.f_96544_ - this.imageHeight) / 2;
        this.whitelistSelected = new CheckBox(this.leftPos + 7, this.topPos + 20, this.isWhitelist, box -> {
            this.isWhitelist = !this.isWhitelist;
        });
        this.m_142416_((GuiEventListener)this.whitelistSelected);
        this.selectedMobsShown = new CheckBox(this.leftPos + 7, this.topPos + 60, false, box -> {
            this.searchBar.m_94144_("");
            this.refreshSearchResults();
        });
        this.m_142416_((GuiEventListener)this.selectedMobsShown);
        this.searchBar = new EditBox(this.f_96547_, this.leftPos + 121, this.topPos + 8, 85, 12, (Component)Component.m_237119_());
        this.searchBar.m_94199_(50);
        this.searchBar.m_94182_(false);
        this.searchBar.m_94202_(0xFFFFFF);
        this.m_7787_((GuiEventListener)this.searchBar);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        graphics.m_280218_(TEXTURE_BACKDROP, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        graphics.m_280588_(this.leftPos + 28, this.topPos + 23, this.leftPos + 28 + 90, this.topPos + 23 + 92);
        LivingEntity entity = EntityRenderingUtil.fetchEntity(this.hoveredEntityName, (Level)Minecraft.m_91087_().f_91073_);
        int scale = EntityRenderingUtil.getAdjustedMobScale(this.hoveredEntityName);
        if (entity != null) {
            EntityRenderingUtil.drawEntityOnScreen(graphics, this.leftPos + 70, this.topPos + 110, scale, (float)(this.leftPos + 69) - (float)mouseX, (float)(this.topPos + 110) - entity.m_20192_() * (float)scale - (float)mouseY, entity, false);
        }
        graphics.m_280618_();
        graphics.m_280218_(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.leftPos + 7, this.topPos + 7, 0x404040, false);
        graphics.m_280218_(TEXTURE, this.leftPos + 8, this.topPos + 35, this.isWhitelist ? 44 : 30, 125, 12, 14);
        graphics.m_280218_(TEXTURE, this.leftPos + 8, this.topPos + 75, 58, 125, 12, 12);
        this.searchBar.m_88315_(graphics, mouseX, mouseY, partialTicks);
        int k = (int)(81.0f * this.scrollOffs);
        graphics.m_280218_(TEXTURE, this.leftPos + 218, this.topPos + 21 + k, this.scrolling ? 12 : 0, 153, 12, 15);
        this.renderEntityNames(graphics, this.leftPos + 123, this.topPos + 26, this.startIndex + 5);
        if (this.isHovering(121, 24, 90, 90, mouseX, mouseY) && !this.filteredMobs.isEmpty()) {
            int y = (mouseY - this.topPos - 26) / 18;
            this.hoveredEntityName = ResourceLocation.m_135820_((String)((String)this.filteredMobs.get(Mth.m_14045_((int)(this.startIndex + y), (int)0, (int)Math.max(0, this.filteredMobs.size() - 1))).getFirst()));
            if (this.hoveredEntityName != null && this.startIndex + y < this.filteredMobs.size()) {
                graphics.m_280218_(TEXTURE, this.leftPos + 121, this.topPos + 26 + y * 18, 0, 168, 90, 15);
                ArrayList<FormattedCharSequence> tooltipParts = new ArrayList<FormattedCharSequence>();
                tooltipParts.add(Component.m_237113_((String)this.hoveredEntityName.toString()).m_7532_());
                this.visibleTags.forEach(key -> {
                    if (((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.hoveredEntityName)).m_204039_(key)) {
                        tooltipParts.add(Component.m_237113_((String)("#" + key.f_203868_())).m_130940_(ChatFormatting.DARK_PURPLE).m_7532_());
                    }
                });
                graphics.m_280245_(this.f_96547_, tooltipParts, mouseX, mouseY);
            }
        }
        if (this.whitelistSelected.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.rats.mob_filter.whitelist"), mouseX, mouseY);
        }
        if (this.selectedMobsShown.m_274382_()) {
            graphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"gui.rats.mob_filter.selected_mobs"), mouseX, mouseY);
        }
    }

    private void renderEntityNames(GuiGraphics graphics, int startX, int startY, int startIndex) {
        for (int i = this.startIndex; i < startIndex && i < this.filteredMobs.size(); ++i) {
            int j = i - this.startIndex;
            int y = startY + j * 18;
            this.renderScrollingString(graphics, (Component)this.filteredMobs.get(i).getSecond(), startX, y, startX + 88, y + 15, this.selectedMobs.contains(this.filteredMobs.get(i).getFirst()) ? 5046016 : 0xFFFFFF);
        }
    }

    protected void renderScrollingString(GuiGraphics graphics, Component text, int startX, int startY, int width, int height, int color) {
        int i = this.f_96547_.m_92852_((FormattedText)text);
        int j = (startY + height - 9) / 2 + 1;
        int k = width - startX;
        if (i > k) {
            int l = i - k + 2;
            double d0 = (double)Util.m_137550_() / 1000.0;
            double d1 = Math.max((double)l * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * d0 / d1)) / 2.0 + 0.5;
            double d3 = Mth.m_14139_((double)d2, (double)0.0, (double)l);
            graphics.m_280588_(startX - 1, startY, width - 1, height);
            graphics.m_280614_(this.f_96547_, text, startX - (int)d3, j, color, false);
            graphics.m_280618_();
        } else {
            graphics.m_280614_(this.f_96547_, text, startX, j, color, false);
        }
    }

    public void m_86600_() {
        this.searchBar.m_94120_();
    }

    private int getOffscreenRows() {
        return this.filteredMobs.size() - 5;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragSizeX, double dragSizeY) {
        if (this.scrolling && this.filteredMobs.size() > 5) {
            int i = this.topPos + 21;
            int j = i + 96;
            this.scrollOffs = ((float)mouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragSizeX, dragSizeY);
    }

    public boolean m_6050_(double x, double y, double direction) {
        if (this.filteredMobs.size() > 5) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - direction / (double)i);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int index = this.startIndex + 5;
        this.searchBar.m_93692_(this.isHovering(119, 6, 96, 12, mouseX, mouseY));
        if (button == 0 && this.isHovering(218, 21, 12, 96, mouseX, mouseY)) {
            this.scrolling = true;
        }
        for (int l = this.startIndex; l < Math.min(this.filteredMobs.size(), index); ++l) {
            int selectedIndex = l - this.startIndex;
            if (!this.isHovering(121, 24 + selectedIndex * 18, 90, 15, mouseX, mouseY)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            if (this.selectedMobs.contains(this.filteredMobs.get(l).getFirst())) {
                this.selectedMobs.remove(this.filteredMobs.get(l).getFirst());
            } else {
                this.selectedMobs.add((String)this.filteredMobs.get(l).getFirst());
            }
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_5534_(char character, int amount) {
        String s = this.searchBar.m_94155_();
        if (character == '`') {
            RatsMod.LOGGER.debug(this.filteredMobs);
            return true;
        }
        if (this.isValidCharacter(character) && this.searchBar.m_5534_(character, amount)) {
            if (!Objects.equals(s, this.searchBar.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    private boolean isValidCharacter(char character) {
        return Character.isAlphabetic(character) || Character.isDigit(character) || character == '#' || character == ':';
    }

    public boolean m_7933_(int key, int value, int modifier) {
        String s = this.searchBar.m_94155_();
        if (this.searchBar.m_7933_(key, value, modifier)) {
            if (!Objects.equals(s, this.searchBar.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return key != 256 || super.m_7933_(key, value, modifier);
    }

    private void refreshSearchResults() {
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
        this.filteredMobs.clear();
        this.visibleTags.clear();
        if (this.selectedMobsShown.selected) {
            this.selectedMobs.forEach(s -> this.filteredMobs.add((Pair<String, Component>)Pair.of((Object)s, (Object)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)s))).m_20676_())));
        } else if (this.searchBar.m_94155_().startsWith("#")) {
            String tagName = this.searchBar.m_94155_().substring(1).trim();
            List<TagKey> tags = BuiltInRegistries.f_256780_.m_203613_().filter(key -> key.f_203868_().toString().contains(tagName)).toList();
            if (!tags.isEmpty()) {
                tags.forEach(key -> {
                    this.filteredMobs.addAll(this.allMobs.stream().filter(pair -> ForgeRegistries.ENTITY_TYPES.tags().getTag(key).contains((Object)((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.m_135820_((String)((String)pair.getFirst())))))).toList());
                    this.visibleTags.add((TagKey<EntityType<?>>)key);
                });
            }
        } else {
            this.filteredMobs.addAll(this.allMobs.stream().filter(s -> ((String)s.getFirst()).toLowerCase(Locale.ROOT).contains(this.searchBar.m_94155_()) || ((Component)s.getSecond()).getString().toLowerCase(Locale.ROOT).contains(this.searchBar.m_94155_())).toList());
        }
    }

    protected boolean isHovering(int startX, int startY, int xSize, int ySize, double mouseX, double mouseY) {
        return mouseX >= (double)((startX += this.leftPos) - 1) && mouseX < (double)(startX + xSize + 1) && mouseY >= (double)((startY += this.topPos) - 1) && mouseY < (double)(startY + ySize + 1);
    }

    public void m_7379_() {
        RatsNetworkHandler.CHANNEL.sendToServer((Object)new UpdateMobFilterPacket(this.hand, this.isWhitelist, this.selectedMobs));
        super.m_7379_();
    }

    public boolean m_7043_() {
        return false;
    }

    public static class CheckBox
    extends AbstractButton {
        private boolean selected;
        private final OnPress press;

        public CheckBox(int x, int y, boolean selected, OnPress press) {
            super(x, y, 12, 12, (Component)Component.m_237119_());
            this.selected = selected;
            this.press = press;
        }

        public void m_5691_() {
            this.selected = !this.selected;
            this.press.onPress(this);
        }

        protected void m_168797_(NarrationElementOutput output) {
            output.m_169146_(NarratedElementType.TITLE, (Component)this.m_5646_());
            if (this.f_93623_) {
                if (this.m_93696_()) {
                    output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.focused"));
                } else {
                    output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.checkbox.usage.hovered"));
                }
            }
        }

        public void m_87963_(GuiGraphics graphics, int x, int y, float partialTicks) {
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
            RenderSystem.enableBlend();
            graphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), this.m_274382_() ? 14 : 0, this.selected ? 138 : 124, 14, 14);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public static interface OnPress {
            public void onPress(CheckBox var1);
        }
    }
}

