/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.client.gui.RatCraftingRecipeBookComponent;
import com.github.alexthe666.rats.server.inventory.RatCraftingTableMenu;
import com.github.alexthe666.rats.server.message.CycleRatRecipePacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeUpdateListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.CraftingRecipe;

public class RatCraftingTableScreen
extends AbstractContainerScreen<RatCraftingTableMenu>
implements RecipeUpdateListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("rats", "textures/gui/container/rat_crafting_table.png");
    private static final ResourceLocation RECIPE_BUTTON_LOCATION = new ResourceLocation("textures/gui/recipe_button.png");
    private final Inventory playerInventory;
    private final RatCraftingTableMenu table;
    private final RatCraftingRecipeBookComponent recipeBook = new RatCraftingRecipeBookComponent();
    private boolean widthTooNarrow;

    public RatCraftingTableScreen(RatCraftingTableMenu container, Inventory inv, Component name) {
        super((AbstractContainerMenu)container, inv, name);
        this.playerInventory = inv;
        this.table = container;
        this.f_97727_ = 211;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.widthTooNarrow = this.f_96543_ < 379;
        this.recipeBook.m_100309_(this.f_96543_, this.f_96544_, this.f_96541_, this.widthTooNarrow, (RecipeBookMenu)this.f_97732_);
        this.f_97735_ = this.recipeBook.m_181401_(this.f_96543_, this.f_97726_);
        this.f_169369_.clear();
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 128, this.f_97736_ + 65, 20, 18, 0, 0, 19, RECIPE_BUTTON_LOCATION, button -> {
            this.recipeBook.m_100384_();
            this.f_97735_ = this.recipeBook.m_181401_(this.f_96543_, this.f_97726_);
            this.m_7856_();
        }));
        this.m_142416_((GuiEventListener)new CycleResultButton(this.f_97735_ + 100, this.f_97736_ + 58, false, button -> {
            this.table.incrementRecipeIndex(false);
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new CycleRatRecipePacket(this.table.getCraftingTable().m_58899_().m_121878_(), false));
        }));
        this.m_142416_((GuiEventListener)new CycleResultButton(this.f_97735_ + 100, this.f_97736_ + 28, true, button -> {
            this.table.incrementRecipeIndex(true);
            RatsNetworkHandler.CHANNEL.sendToServer((Object)new CycleRatRecipePacket(this.table.getCraftingTable().m_58899_().m_121878_(), true));
        }));
        this.m_7787_((GuiEventListener)this.recipeBook);
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBook.m_100386_();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        if (this.recipeBook.m_100385_() && this.widthTooNarrow) {
            this.m_7286_(graphics, partialTicks, mouseX, mouseY);
            this.recipeBook.m_88315_(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.recipeBook.m_88315_(graphics, mouseX, mouseY, partialTicks);
            super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }
        this.m_280072_(graphics, mouseX, mouseY);
        this.recipeBook.m_280545_(graphics, this.f_97735_, this.f_97736_, mouseX, mouseY);
        RenderSystem.disableDepthTest();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int xPos = 36 + i * 18;
                int yPos = 22 + j * 18;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85837_((double)this.f_97735_, (double)this.f_97736_, 300.0);
                graphics.m_280509_(xPos, yPos, xPos + 16, yPos + 16, -1618244725);
                graphics.m_280168_().m_85849_();
            }
        }
        RenderSystem.enableDepthTest();
        Optional<CraftingRecipe> recipe = this.table.getCraftingTable().getGuideRecipe();
        if (recipe.isPresent() && !this.table.m_38853_(0).m_6657_()) {
            graphics.m_280480_(recipe.get().m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()), this.f_97735_ + 130, this.f_97736_ + 40);
            RenderSystem.disableDepthTest();
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_85837_((double)this.f_97735_, (double)this.f_97736_, 300.0);
            graphics.m_280509_(130, 40, 146, 56, -1618244725);
            graphics.m_280168_().m_85849_();
            RenderSystem.enableDepthTest();
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        graphics.m_280218_(TEXTURE, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int l = this.table.getCookProgressionScaled();
        graphics.m_280218_(TEXTURE, this.f_97735_ + 96, this.f_97736_ + 39, 0, 211, l, 16);
        if (this.table.getCraftingTable().hasRat()) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 8, this.f_97736_ + 20, 176, 0, 21, 21);
        } else {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 7, this.f_97736_ + 40, 198, 0, 21, 21);
        }
        if (this.table.getCraftingTable().m_7928_() == null) {
            graphics.m_280218_(TEXTURE, this.f_97735_ + 95, this.f_97736_ + 38, 220, 0, 21, 21);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        Font font = this.f_96547_;
        String s = this.m_96636_().getString();
        graphics.drawString(this.f_96547_, s, (float)this.f_97726_ / 2.0f - (float)font.m_92895_(s) / 2.0f, 5.0f, 0x404040, false);
        graphics.m_280056_(this.f_96547_, this.playerInventory.m_5446_().getString(), 8, this.f_97727_ - 93, 0x404040, false);
        graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"container.rats.rat_crafting_table.input"), 8, this.f_97727_ - 125, 0x404040, false);
        int screenW = (this.f_96543_ - 248) / 2;
        int screenH = (this.f_96544_ - 166) / 2;
        if (!this.table.getCraftingTable().hasRat() && this.m_6774_(6, 34, 25, 29, mouseX, mouseY)) {
            MutableComponent ratDesc = Component.m_237115_((String)"container.rats.rat_crafting_table.requires_rat");
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)ratDesc, 200), mouseX - screenW - 40, mouseY - screenH + 10);
        }
    }

    public boolean shouldRenderButtons() {
        return this.table.getCraftingTable().getPossibleRecipes().size() > 1;
    }

    protected boolean m_6774_(int slotX, int slotY, int width, int height, double mouseX, double mouseY) {
        return (!this.widthTooNarrow || !this.recipeBook.m_100385_()) && super.m_6774_(slotX, slotY, width, height, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.recipeBook.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.recipeBook);
            return true;
        }
        return this.widthTooNarrow && this.recipeBook.m_100385_() || super.m_6375_(mouseX, mouseY, button);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int leftPos, int topPos, int button) {
        boolean flag = mouseX < (double)leftPos || mouseY < (double)topPos || mouseX >= (double)(leftPos + this.f_97726_) || mouseY >= (double)(topPos + this.f_97727_);
        return this.recipeBook.m_100297_(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_, button) && flag;
    }

    protected void m_6597_(Slot slot, int slotIndex, int button, ClickType type) {
        super.m_6597_(slot, slotIndex, button, type);
        this.recipeBook.m_6904_(slot);
    }

    public void m_6916_() {
        this.recipeBook.m_100387_();
    }

    public RecipeBookComponent m_5564_() {
        return this.recipeBook;
    }

    private static class CycleResultButton
    extends Button {
        private final boolean up;

        public CycleResultButton(int x, int y, boolean up, Button.OnPress onClick) {
            super(x, y, 14, 9, (Component)Component.m_237119_(), onClick, message -> Component.m_237119_());
            this.up = up;
        }

        public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            RatCraftingTableScreen table;
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof RatCraftingTableScreen && !(table = (RatCraftingTableScreen)screen).shouldRenderButtons()) {
                return;
            }
            if (this.f_93624_) {
                this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
                int textureX = 22;
                int textureY = 211;
                if (this.f_93622_) {
                    textureX += this.f_93618_;
                }
                if (!this.up) {
                    textureY += this.f_93619_;
                }
                graphics.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), textureX, textureY, this.f_93618_, this.f_93619_);
            }
        }
    }
}

