/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.client.gui.CommandPressButton;
import com.github.alexthe666.rats.client.gui.UpgradeVisibilityButton;
import com.github.alexthe666.rats.client.util.EntityRenderingUtil;
import com.github.alexthe666.rats.server.entity.rat.RatCommand;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.inventory.RatMenu;
import com.github.alexthe666.rats.server.message.RatCommandPacket;
import com.github.alexthe666.rats.server.message.RatUpgradeVisibilityPacket;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.misc.RatUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class RatScreen
extends AbstractContainerScreen<RatMenu> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats", "textures/gui/container/rat_inventory.png");
    private static final ResourceLocation TEXTURE_BACKDROP = new ResourceLocation("rats", "textures/gui/container/rat_inventory_backdrop.png");
    private int currentDisplayCommand = 0;
    private final TamedRat rat;

    public RatScreen(RatMenu container, Inventory inv, TamedRat rat) {
        super((AbstractContainerMenu)container, inv, rat.m_5446_());
        this.rat = rat;
        this.f_97726_ = 192;
        this.f_97727_ = 166;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.f_169369_.clear();
        int i = (this.f_96543_ - 248) / 2;
        int j = (this.f_96544_ - 166) / 2;
        if (!this.rat.m_6162_()) {
            this.m_142416_((GuiEventListener)new ChangeCommandButton(i + 116, j + 54, false, button -> {
                --this.currentDisplayCommand;
                this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
            }));
            this.m_142416_((GuiEventListener)new ChangeCommandButton(i + 199, j + 54, true, button -> {
                ++this.currentDisplayCommand;
                this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
            }));
            this.m_142416_((GuiEventListener)new CommandPressButton(i + 123, j + 52, button -> {
                this.rat.setCommand(RatCommand.values()[this.currentDisplayCommand]);
                RatsNetworkHandler.CHANNEL.sendToServer((Object)new RatCommandPacket(this.rat.m_19879_(), this.currentDisplayCommand));
            }));
            this.m_142416_((GuiEventListener)new CommandPressButton(i + 123, j + 52, button -> {
                this.rat.setCommand(RatCommand.values()[this.currentDisplayCommand]);
                RatsNetworkHandler.CHANNEL.sendToServer((Object)new RatCommandPacket(this.rat.m_19879_(), this.currentDisplayCommand));
            }));
            this.m_142416_((GuiEventListener)new UpgradeVisibilityButton(i + 39, j + 15, this.rat.isSlotVisible(EquipmentSlot.CHEST), button -> {
                ((UpgradeVisibilityButton)button).toggleVisibility();
                this.rat.setSlotVisibility(EquipmentSlot.CHEST, ((UpgradeVisibilityButton)button).getUpgradeVisibility());
                RatsNetworkHandler.CHANNEL.sendToServer((Object)new RatUpgradeVisibilityPacket(this.rat.m_19879_(), EquipmentSlot.CHEST, ((UpgradeVisibilityButton)button).getUpgradeVisibility()));
            }));
            this.m_142416_((GuiEventListener)new UpgradeVisibilityButton(i + 39, j + 33, this.rat.isSlotVisible(EquipmentSlot.LEGS), button -> {
                ((UpgradeVisibilityButton)button).toggleVisibility();
                this.rat.setSlotVisibility(EquipmentSlot.LEGS, ((UpgradeVisibilityButton)button).getUpgradeVisibility());
                RatsNetworkHandler.CHANNEL.sendToServer((Object)new RatUpgradeVisibilityPacket(this.rat.m_19879_(), EquipmentSlot.LEGS, ((UpgradeVisibilityButton)button).getUpgradeVisibility()));
            }));
            this.m_142416_((GuiEventListener)new UpgradeVisibilityButton(i + 39, j + 51, this.rat.isSlotVisible(EquipmentSlot.FEET), button -> {
                ((UpgradeVisibilityButton)button).toggleVisibility();
                this.rat.setSlotVisibility(EquipmentSlot.FEET, ((UpgradeVisibilityButton)button).getUpgradeVisibility());
                RatsNetworkHandler.CHANNEL.sendToServer((Object)new RatUpgradeVisibilityPacket(this.rat.m_19879_(), EquipmentSlot.FEET, ((UpgradeVisibilityButton)button).getUpgradeVisibility()));
            }));
        }
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        this.m_280273_(graphics);
        int k = (this.f_96543_ - this.f_97726_) / 2;
        int l = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(TEXTURE_BACKDROP, k - 8, l, 0, 0, this.f_97726_, this.f_97727_);
        EntityRenderingUtil.drawEntityOnScreen(graphics, k + 42, l + 64, 70, (float)(k + 51) - (float)mouseX, (float)(l + 75 - 50) - (float)mouseY, (LivingEntity)this.rat, false);
        graphics.m_280218_(TEXTURE, k - 8, l, 0, 0, this.f_97726_, this.f_97727_);
        graphics.m_280218_(TEXTURE, k + 52, l + 20, this.rat.isMale() ? 0 : 16, 209, 16, 16);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        MutableComponent commandText;
        graphics.m_280614_(this.f_96547_, this.m_96636_(), this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.m_96636_()) / 2, 6, 0x404040, false);
        MutableComponent commandDesc = Component.m_237115_((String)"entity.rats.rat.current_command");
        graphics.m_280614_(this.f_96547_, (Component)commandDesc, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)commandDesc) / 2 + 38, 19, 0x404040, false);
        MutableComponent command = Component.m_237115_((String)this.rat.getCommand().getTranslateName());
        graphics.m_280614_(this.f_96547_, (Component)command, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)command) / 2 + 36, 31, 0xFFFFFF, false);
        MutableComponent statusDesc = Component.m_237115_((String)"entity.rats.rat.command_set");
        graphics.m_280614_(this.f_96547_, (Component)statusDesc, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)statusDesc) / 2 + 36, 44, 0x404040, false);
        RatCommand command1 = RatUtils.wrapCommand(this.currentDisplayCommand);
        MutableComponent command2 = Component.m_237115_((String)command1.getTranslateName());
        graphics.m_280614_(this.f_96547_, (Component)command2, this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)command2) / 2 + 36, 56, 0xFFFFFF, false);
        int i = (this.f_96543_ - 248) / 2;
        int j = (this.f_96544_ - 166) / 2;
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 22 && mouseY < j + 45) {
            commandText = Component.m_237115_((String)this.rat.getCommand().getTranslateDescription());
            String[] everySpace = commandText.getString().split(" ");
            int currentStrLength = 0;
            StringBuilder builtString = new StringBuilder();
            ArrayList<String> list = new ArrayList<String>();
            for (String s : everySpace) {
                builtString.append(s).append(" ");
                if ((currentStrLength += this.f_96547_.m_92895_(s + " ")) < 95) continue;
                list.add(builtString.toString());
                builtString = new StringBuilder();
                currentStrLength = 0;
            }
            ArrayList<MutableComponent> convertedList = new ArrayList<MutableComponent>();
            for (String str : list) {
                convertedList.add(Component.m_237113_((String)str));
            }
            graphics.m_280245_(this.f_96547_, Lists.transform(convertedList, Component::m_7532_), mouseX - i - 30, mouseY - j + 10);
        }
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 53 && mouseY < j + 69) {
            commandText = Component.m_237115_((String)command1.getTranslateDescription());
            graphics.m_280245_(this.f_96547_, this.f_96547_.m_92923_((FormattedText)commandText, 110), mouseX - i - 30, mouseY - j + 10);
        }
    }
}

