/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.block;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.rats.server.block.TrashCanBlock;
import com.github.alexthe666.rats.server.block.entity.TrashCanBlockEntity;
import com.google.common.collect.ImmutableList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.properties.Property;

public class TrashCanModel<T extends Entity>
extends AdvancedEntityModel<T> {
    public final AdvancedModelBox can;
    public final AdvancedModelBox lid;
    public final AdvancedModelBox trash;
    public final AdvancedModelBox handle1;
    public final AdvancedModelBox handle2;
    public final AdvancedModelBox handle3;

    public TrashCanModel() {
        this.texWidth = 64;
        this.texHeight = 64;
        this.lid = new AdvancedModelBox((AdvancedEntityModel)this, 0, 32);
        this.lid.setRotationPoint(0.0f, 6.0f, 7.0f);
        this.lid.addBox(-8.0f, -2.0f, -15.0f, 16.0f, 2.0f, 16.0f, -0.01f);
        this.handle1 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.handle1.setRotationPoint(0.0f, -4.0f, -7.0f);
        this.handle1.addBox(-2.0f, -0.5f, -0.5f, 4.0f, 1.0f, 1.0f, 0.0f);
        this.handle3 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.handle3.setRotationPoint(2.0f, 0.0f, 0.0f);
        this.handle3.addBox(-1.0f, 0.5f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f);
        this.can = new AdvancedModelBox((AdvancedEntityModel)this, 0, 0);
        this.can.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.can.addBox(-7.0f, -18.0f, -7.0f, 14.0f, 18.0f, 14.0f, 0.0f);
        this.trash = new AdvancedModelBox((AdvancedEntityModel)this, 0, 50);
        this.trash.setRotationPoint(0.0f, 24.0f, 0.0f);
        this.trash.addBox(-7.0f, 0.0f, -7.0f, 14.0f, 0.0f, 14.0f, 0.0f);
        this.handle2 = new AdvancedModelBox((AdvancedEntityModel)this, 0, 4);
        this.handle2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.handle2.addBox(-2.0f, 0.5f, -0.5f, 1.0f, 2.0f, 1.0f, 0.0f);
        this.lid.addChild((BasicModelPart)this.handle1);
        this.handle1.addChild((BasicModelPart)this.handle3);
        this.handle1.addChild((BasicModelPart)this.handle2);
        this.updateDefaultPose();
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.lid, (Object)this.can, (Object)this.trash);
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.lid, (Object)this.can, (Object)this.trash, (Object)this.handle1, (Object)this.handle2, (Object)this.handle3);
    }

    public void animate(TrashCanBlockEntity trashCan) {
        this.resetToDefaultPose();
        if ((Integer)trashCan.m_58900_().m_61143_((Property)TrashCanBlock.LEVEL) <= 0) {
            this.trash.showModel = false;
            this.trash.rotationPointY = 24.0f;
        } else {
            this.trash.showModel = true;
            this.trash.rotationPointY = 24.0f - 2.5f * (float)((Integer)trashCan.m_58900_().m_61143_((Property)TrashCanBlock.LEVEL)).intValue();
        }
        float openProgress = trashCan.prevLidProgress + (trashCan.lidProgress - trashCan.prevLidProgress) * Minecraft.m_91087_().getPartialTick();
        this.lid.rotateAngleX += (float)Math.toRadians(-70.0 * (double)(openProgress / 20.0f));
    }
}

