/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.model.entity;

import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.monster.PiedPiper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;

public class PiedPiperModel<T extends PiedPiper>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart nose;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;

    public PiedPiperModel(ModelPart root) {
        this.root = root;
        this.head = root.m_171324_("head");
        this.nose = this.head.m_171324_("nose");
        this.rightArm = root.m_171324_("right_arm");
        this.leftArm = root.m_171324_("left_arm");
        this.rightLeg = root.m_171324_("right_leg");
        this.leftLeg = root.m_171324_("left_leg");
    }

    public static LayerDefinition create() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partdefinition = mesh.m_171576_();
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -1.0f, -2.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)-4.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171488_(-4.5f, -5.0f, -6.0f, 9.0f, 5.0f, 12.0f, new CubeDeformation(0.25f)).m_171514_(32, 0).m_171481_(-2.5f, -7.0f, -4.0f, 5.0f, 2.0f, 8.0f), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        hat.m_171599_("feather", CubeListBuilder.m_171558_().m_171514_(44, 0).m_171481_(0.0f, -9.0f, -2.0f, 0.0f, 10.0f, 10.0f), PartPose.m_171423_((float)-3.0f, (float)-5.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(30, 46).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(30, 46).m_171480_().m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(48, 46).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(48, 46).m_171480_().m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private ModelPart getArm(HumanoidArm arm) {
        return arm == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm arm, PoseStack stack) {
        this.getArm(arm).m_104299_(stack);
        stack.m_252880_(arm == HumanoidArm.RIGHT ? 0.25f : -0.25f, 0.2f, 0.1f);
        stack.m_252781_(Axis.f_252403_.m_252977_(arm == HumanoidArm.RIGHT ? 10.0f : -10.0f));
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.rightArm.f_104203_ = -0.62831855f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = -0.62831855f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = -1.4137167f;
            this.rightLeg.f_104204_ = 0.31415927f;
            this.rightLeg.f_104205_ = 0.07853982f;
            this.leftLeg.f_104203_ = -1.4137167f;
            this.leftLeg.f_104204_ = -0.31415927f;
            this.leftLeg.f_104205_ = -0.07853982f;
        } else {
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            this.rightArm.f_104204_ = 0.0f;
            this.rightArm.f_104205_ = 0.0f;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            this.leftArm.f_104204_ = 0.0f;
            this.leftArm.f_104205_ = 0.0f;
            this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            this.rightLeg.f_104204_ = 0.0f;
            this.rightLeg.f_104205_ = 0.0f;
            this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
            this.leftLeg.f_104204_ = 0.0f;
            this.leftLeg.f_104205_ = 0.0f;
        }
        if (entity.m_21055_((Item)RatsItemRegistry.RAT_FLUTE.get())) {
            float f = 0.01f * (float)(entity.m_19879_() % 10);
            this.nose.f_104204_ = 0.0f;
            this.nose.f_104205_ = Mth.m_14089_((float)((float)((PiedPiper)entity).f_19797_ * f)) * 2.5f * ((float)Math.PI / 180);
            this.nose.f_104203_ = -1.2f;
            if (entity.m_21526_()) {
                this.leftArm.f_104204_ = 0.3f + this.head.f_104204_;
                this.rightArm.f_104204_ = -0.6f + this.head.f_104204_;
                this.leftArm.f_104203_ = -1.5707964f + this.head.f_104203_ + 0.1f;
                this.rightArm.f_104203_ = -1.5f + this.head.f_104203_;
            } else {
                this.rightArm.f_104204_ = -0.3f + this.head.f_104204_;
                this.leftArm.f_104204_ = 0.6f + this.head.f_104204_;
                this.rightArm.f_104203_ = -1.5707964f + this.head.f_104203_ + 0.1f;
                this.leftArm.f_104203_ = -1.5f + this.head.f_104203_;
            }
        } else {
            this.nose.f_104204_ = 0.0f;
            this.nose.f_104205_ = 0.0f;
            this.nose.f_104203_ = 0.0f;
        }
    }
}

