/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.block;

import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.server.block.ChunkyCheeseTokenBlock;
import com.github.alexthe666.rats.server.block.entity.RatlantisTokenBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix4f;

public class RatlantisTokenRenderer
implements BlockEntityRenderer<RatlantisTokenBlockEntity> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public RatlantisTokenRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(RatlantisTokenBlockEntity entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light, int overlay) {
        float progress = 0.0f;
        float f2 = 0.0f;
        if (entity.m_58904_() != null && entity.m_58904_().m_8055_(entity.m_58899_()).m_60734_() instanceof ChunkyCheeseTokenBlock) {
            float f1;
            progress = (float)(entity.tickCount - 1) + partialTicks;
            for (f1 = entity.ratRotation - entity.ratRotationPrev; f1 >= (float)Math.PI; f1 -= (float)Math.PI * 2) {
            }
            while (f1 < (float)(-Math.PI)) {
                f1 += (float)Math.PI * 2;
            }
            f2 = entity.ratRotationPrev + f1 * Minecraft.m_91087_().getPartialTick();
        }
        stack.m_85836_();
        stack.m_85837_(0.5, 0.5, 0.5);
        stack.m_85836_();
        float upwardSpeed = Math.max(0.0f, (progress - 150.0f) / 150.0f);
        stack.m_85837_(0.0, Math.min(1.5, (double)upwardSpeed), 0.0);
        stack.m_85836_();
        float tokenScale = 0.5f;
        float rotateSpeed = progress / 3.0f * progress / 3.0f;
        float masterRot = rotateSpeed - f2 * 57.295776f - 90.0f;
        stack.m_85841_(tokenScale, tokenScale, tokenScale);
        stack.m_252781_(Axis.f_252436_.m_252977_(masterRot));
        Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)RatlantisBlockRegistry.CHUNKY_CHEESE_TOKEN.get()), ItemDisplayContext.FIXED, light, overlay, stack, buffer, null, 0);
        stack.m_85849_();
        stack.m_85836_();
        if (progress > 150.0f) {
            float elapsedTime = (progress - 150.0f) / 200.0f;
            float amplifier = 0.0f;
            if (elapsedTime > 0.8f) {
                amplifier = 0.2f;
            }
            RandomSource random = RandomSource.m_216335_((long)432L);
            VertexConsumer consumer = buffer.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_85837_(0.0, 0.0, -0.0);
            stack.m_85841_(0.2f, 0.8f, 0.2f);
            int i = 0;
            while ((float)i < (elapsedTime + elapsedTime * elapsedTime) / 2.0f * 10.0f) {
                stack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f + elapsedTime * 90.0f));
                float yAngle = random.m_188501_() * 20.0f + 5.0f + amplifier * 2.0f;
                float xAngle = random.m_188501_() * 2.0f + 1.0f + amplifier * 2.0f;
                Matrix4f matrix = stack.m_85850_().m_252922_();
                int alpha = (int)(255.0f * (1.0f - amplifier));
                RatlantisTokenRenderer.vertex01(consumer, matrix, alpha);
                RatlantisTokenRenderer.vertex2(consumer, matrix, yAngle, xAngle);
                RatlantisTokenRenderer.vertex3(consumer, matrix, yAngle, xAngle);
                RatlantisTokenRenderer.vertex01(consumer, matrix, alpha);
                RatlantisTokenRenderer.vertex3(consumer, matrix, yAngle, xAngle);
                RatlantisTokenRenderer.vertex4(consumer, matrix, yAngle, xAngle);
                RatlantisTokenRenderer.vertex01(consumer, matrix, alpha);
                RatlantisTokenRenderer.vertex4(consumer, matrix, yAngle, xAngle);
                RatlantisTokenRenderer.vertex2(consumer, matrix, yAngle, xAngle);
                ++i;
            }
            stack.m_85849_();
        }
        stack.m_85849_();
        stack.m_85836_();
        if (progress > 450.0f) {
            float progMod = progress - 450.0f;
            float blocksScale = Math.min(progMod / 50.0f, 2.0f);
            stack.m_85841_(blocksScale, blocksScale, blocksScale);
            stack.m_252880_(0.0f, 0.0f, 0.0f);
            stack.m_85836_();
            stack.m_252880_(0.0f, 0.75f * blocksScale * 0.5f, 0.0f);
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)RatsBlockRegistry.MARBLED_CHEESE_RAW.get()), ItemDisplayContext.FIXED, light, overlay, stack, buffer, null, 0);
            stack.m_85849_();
            stack.m_85836_();
            stack.m_85837_(0.0, 0.5 - (double)(1.25f * blocksScale * 0.5f), 0.0);
            Minecraft.m_91087_().m_91291_().m_269128_(new ItemStack((ItemLike)RatsBlockRegistry.MARBLED_CHEESE_RAW.get()), ItemDisplayContext.FIXED, light, overlay, stack, buffer, null, 0);
            stack.m_85849_();
        }
        stack.m_85849_();
        stack.m_85849_();
        stack.m_85849_();
    }

    private static void vertex01(VertexConsumer consumer, Matrix4f matrix, int alpha) {
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        consumer.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
    }

    private static void vertex2(VertexConsumer consumer, Matrix4f matrix, float y, float x) {
        consumer.m_252986_(matrix, -HALF_SQRT_3 * x, y, -0.5f * x).m_6122_(255, 169, 33, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer consumer, Matrix4f matrix, float y, float x) {
        consumer.m_252986_(matrix, HALF_SQRT_3 * x, y, -0.5f * x).m_6122_(255, 169, 33, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer consumer, Matrix4f matrix, float y, float x) {
        consumer.m_252986_(matrix, 0.0f, y, x).m_6122_(255, 169, 33, 0).m_5752_();
    }
}

