/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity;

import com.github.alexthe666.rats.client.model.entity.StaticRatModel;
import com.github.alexthe666.rats.server.entity.projectile.RatShot;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;

public class RatShotRenderer
extends EntityRenderer<RatShot> {
    private static final RenderType TEXTURE_EYES = RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/glow.png"));
    private static final StaticRatModel<RatShot> MODEL_STATIC_RAT = new StaticRatModel();

    public RatShotRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(RatShot entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        long roundedTime = entity.m_9236_().m_46468_() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        BlockPos ratPos = entity.getLightPosition();
        int brightI = entity.m_9236_().m_45517_(LightLayer.SKY, ratPos);
        int brightJ = entity.m_9236_().m_45517_(LightLayer.BLOCK, ratPos);
        int brightness = night ? brightJ : Math.max(brightI, brightJ);
        stack.m_85836_();
        stack.m_85841_(0.6f, -0.6f, 0.6f);
        float yaw = entity.f_19859_ + (entity.m_146908_() - entity.f_19859_) * partialTicks;
        float pitch = entity.f_19860_ + (entity.m_146909_() - entity.f_19860_) * partialTicks;
        stack.m_252880_(0.0f, -1.5f, 0.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_(yaw - 180.0f));
        stack.m_252781_(Axis.f_252495_.m_252977_(pitch));
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)entity.getColorVariant().getTexture()));
        float f = ((float)entity.f_19797_ + partialTicks) * 0.5f;
        float f1 = 1.0f;
        MODEL_STATIC_RAT.m_6973_(entity, f, f1, (float)entity.f_19797_ + partialTicks, 0.0f, 0.0f);
        MODEL_STATIC_RAT.m_7695_(stack, consumer, light, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false)), 1.0f, 1.0f, 1.0f, 1.0f);
        if (brightness < 7) {
            VertexConsumer iGlowBuffer = buffer.m_6299_(TEXTURE_EYES);
            MODEL_STATIC_RAT.m_7695_(stack, iGlowBuffer, light, OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false)), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        stack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, stack, buffer, light);
    }

    public ResourceLocation getTextureLocation(RatShot entity) {
        return null;
    }
}

