/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LightLayer;

public class RatEyesLayer<T extends AbstractRat, M extends AbstractRatModel<T>>
extends RenderLayer<T, M> {
    protected static final RenderType EYES = RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/glow.png"));
    protected static final RenderType PLAGUE_EYES = RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/plague.png"));

    public RatEyesLayer(RenderLayerParent<T, M> parent) {
        super(parent);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        Rat plagueable;
        long roundedTime = rat.m_9236_().m_46468_() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 23000L;
        BlockPos ratPos = ((AbstractRat)((Object)rat)).getLightPosition();
        int i = rat.m_9236_().m_45517_(LightLayer.SKY, ratPos);
        int j = rat.m_9236_().m_45517_(LightLayer.BLOCK, ratPos);
        int brightness = night ? j : Math.max(i, j);
        if (rat instanceof Rat && (plagueable = (Rat)((Object)rat)).hasPlague()) {
            VertexConsumer consumer = buffer.m_6299_(PLAGUE_EYES);
            ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (brightness < 7) {
            VertexConsumer consumer = buffer.m_6299_(EYES);
            ((AbstractRatModel)this.m_117386_()).m_7695_(stack, consumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }
}

