/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.entity.AbstractRatModel;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.HatItem;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class RatHelmetLayer<T extends AbstractRat, M extends AbstractRatModel<T>>
extends RenderLayer<T, M> {
    private final HumanoidModel<?> ratArmorModel;
    private final TextureAtlas armorTrimAtlas;
    private static final Map<String, ResourceLocation> ARMOR_TEXTURE_RES_MAP = Maps.newHashMap();

    public RatHelmetLayer(RenderLayerParent<T, M> parent, HumanoidModel<?> armorModel) {
        super(parent);
        this.ratArmorModel = armorModel;
        this.armorTrimAtlas = Minecraft.m_91087_().m_91304_().m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, T rat, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        TamedRat tamed;
        ItemStack itemstack = rat.m_6844_(EquipmentSlot.HEAD);
        if (rat instanceof TamedRat && (tamed = (TamedRat)((Object)rat)).getRespawnCountdown() > 0) {
            itemstack = new ItemStack((ItemLike)RatsItemRegistry.HALO_HAT.get());
        }
        if (!itemstack.m_41619_()) {
            stack.m_85836_();
            Item item = itemstack.m_41720_();
            if (item instanceof ArmorItem) {
                ArmorItem armoritem = (ArmorItem)item;
                if (armoritem.m_40402_() == EquipmentSlot.HEAD) {
                    this.ratArmorModel.m_8009_(false);
                    this.ratArmorModel.f_102808_.f_104207_ = true;
                    this.ratArmorModel.f_102809_.f_104207_ = true;
                    Model model = ForgeHooksClient.getArmorModel(rat, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD, this.ratArmorModel);
                    ((AbstractRatModel)this.m_117386_()).translateToHead(stack);
                    if (rat.m_6162_()) {
                        stack.m_85837_(0.0, 0.025, -0.05);
                        stack.m_85841_(0.65f, 0.65f, 0.65f);
                    }
                    stack.m_252880_(0.0f, -0.325f, -0.045f);
                    stack.m_85841_(0.55f, 0.55f, 0.55f);
                    Item item2 = itemstack.m_41720_();
                    if (item2 instanceof HatItem) {
                        HatItem hat = (HatItem)item2;
                        hat.transformOnHead((AbstractRat)((Object)rat), stack);
                    }
                    if (armoritem instanceof DyeableArmorItem) {
                        DyeableArmorItem dyeable = (DyeableArmorItem)armoritem;
                        int i = dyeable.m_41121_(itemstack);
                        float f = (float)(i >> 16 & 0xFF) / 255.0f;
                        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                        float f2 = (float)(i & 0xFF) / 255.0f;
                        this.renderModel(stack, buffer, light, model, f, f1, f2, this.getArmorResource((Entity)rat, itemstack, EquipmentSlot.HEAD, null));
                        this.renderModel(stack, buffer, light, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)rat, itemstack, EquipmentSlot.HEAD, "overlay"));
                    } else {
                        this.renderModel(stack, buffer, light, model, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)rat, itemstack, EquipmentSlot.HEAD, null));
                    }
                    ArmorTrim.m_266285_((RegistryAccess)rat.m_9236_().m_9598_(), (ItemStack)itemstack).ifPresent(trim -> this.renderTrim(armoritem.m_40401_(), stack, buffer, light, (ArmorTrim)trim, model));
                    if (itemstack.m_41790_()) {
                        this.renderGlint(stack, buffer, light, model);
                    }
                }
            } else if (!itemstack.m_150930_((Item)RatsItemRegistry.PARTY_HAT.get())) {
                ((AbstractRatModel)this.m_117386_()).translateToHead(stack);
                stack.m_252880_(0.0f, 0.025f, -0.15f);
                stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                stack.m_85841_(0.5f, 0.5f, 0.5f);
                if (itemstack.m_150930_(((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get()).m_5456_())) {
                    stack.m_252880_(0.0f, -0.1f, 0.1f);
                    stack.m_252781_(Axis.f_252529_.m_252977_(15.0f));
                    if (rat.m_6162_()) {
                        stack.m_85841_(0.4f, 0.4f, 0.4f);
                        stack.m_85837_(0.0, 0.25, 0.0);
                    }
                } else if (itemstack.m_204117_(Tags.Items.HEADS) && ForgeRegistries.ITEMS.getKey((Object)itemstack.m_41720_()).m_135827_().equals("minecraft")) {
                    stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                    stack.m_85837_(0.0, 0.55, -0.0);
                    stack.m_85841_(2.0f, 2.0f, 2.0f);
                    if (rat.m_6162_()) {
                        stack.m_85841_(0.3f, 0.3f, 0.3f);
                        stack.m_85837_(0.0, -0.75, -0.25);
                    }
                }
                stack.m_85837_(0.0, -0.1, 0.0);
                stack.m_85841_(0.85f, 0.85f, 0.85f);
                Minecraft.m_91087_().m_91291_().m_269128_(itemstack, ItemDisplayContext.HEAD, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
            }
            stack.m_85849_();
            stack.m_85836_();
            ItemStack banner = rat.m_6844_(EquipmentSlot.OFFHAND);
            if (banner.m_41720_() instanceof BannerItem) {
                ((AbstractRatModel)this.m_117386_()).translateToBody(stack);
                stack.m_85837_(0.0, -0.5, -0.2);
                stack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
                float sitProgress = ((AbstractRat)((Object)rat)).sitProgress / 20.0f;
                stack.m_252781_(Axis.f_252529_.m_252977_(sitProgress * -40.0f));
                stack.m_85837_(0.0, 0.0, (double)(-sitProgress * 0.04f));
                stack.m_85841_(1.7f, 1.7f, 1.7f);
                Minecraft.m_91087_().m_91291_().m_269128_(banner, ItemDisplayContext.FIXED, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
            }
            stack.m_85849_();
        }
    }

    private void renderModel(PoseStack stack, MultiBufferSource buffer, int light, Model model, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private void renderTrim(ArmorMaterial material, PoseStack stack, MultiBufferSource buffer, int light, ArmorTrim trim, Model model) {
        TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(trim.m_267606_(material));
        VertexConsumer vertexconsumer = textureatlassprite.m_118381_(buffer.m_6299_(Sheets.m_266442_()));
        model.m_7695_(stack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack stack, MultiBufferSource buffer, int light, Model model) {
        model.m_7695_(stack, buffer.m_6299_(RenderType.m_110484_()), light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = ARMOR_TEXTURE_RES_MAP.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlot)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_TEXTURE_RES_MAP.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

