/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.render.entity.layer;

import com.github.alexthe666.rats.client.model.EmptyModel;
import com.github.alexthe666.rats.client.model.entity.RatKingModel;
import com.github.alexthe666.rats.server.entity.monster.boss.RatKing;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;

public class RatKingLayer
extends RenderLayer<RatKing, EmptyModel<RatKing>> {
    private static final RenderType TEXTURE_EYES = RenderType.m_110488_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/eyes/glow.png"));
    private static final RenderType TEXTURE_0 = RenderType.m_110458_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/blue.png"));
    private static final RenderType TEXTURE_1 = RenderType.m_110458_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/black.png"));
    private static final RenderType TEXTURE_2 = RenderType.m_110458_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/brown.png"));
    private static final RenderType TEXTURE_3 = RenderType.m_110458_((ResourceLocation)new ResourceLocation("rats", "textures/entity/rat/green.png"));
    private static final RatKingModel<RatKing> RAT_MODEL = new RatKingModel();

    public RatKingLayer(RenderLayerParent<RatKing, EmptyModel<RatKing>> ratRendererIn) {
        super(ratRendererIn);
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int light, RatKing king, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        long roundedTime = king.m_9236_().m_46468_() % 24000L;
        boolean night = roundedTime >= 13000L && roundedTime <= 22000L;
        BlockPos ratPos = king.getLightPosition();
        int brightI = king.m_9236_().m_45517_(LightLayer.SKY, ratPos);
        int brightJ = king.m_9236_().m_45517_(LightLayer.BLOCK, ratPos);
        int brightness = night ? brightJ : Math.max(brightI, brightJ);
        for (int i = 0; i < 15; ++i) {
            int deathTime = Math.min(Math.max(0, king.f_20919_ - i * 5), 5);
            VertexConsumer consumer = buffer.m_6299_(this.getRatTexture(king.getRatColors(i)));
            stack.m_85836_();
            stack.m_252781_(Axis.f_252436_.m_252977_((float)i * 24.0f));
            stack.m_85837_(0.0, (double)(0.6f + (float)deathTime * 0.01f), -0.8);
            stack.m_85836_();
            stack.m_85841_(0.6f, 0.6f, 0.6f);
            RAT_MODEL.setIndex(i);
            RAT_MODEL.setupAnim(king, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            RAT_MODEL.m_7695_(stack, consumer, light, LivingEntityRenderer.m_115338_((LivingEntity)king, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            if (brightness < 7) {
                VertexConsumer eyes = buffer.m_6299_(TEXTURE_EYES);
                RAT_MODEL.m_7695_(stack, eyes, light, LivingEntityRenderer.m_115338_((LivingEntity)king, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            stack.m_85849_();
            stack.m_85849_();
        }
    }

    private RenderType getRatTexture(int textureIndex) {
        return switch (textureIndex) {
            case 1 -> TEXTURE_1;
            case 2 -> TEXTURE_2;
            case 3 -> TEXTURE_3;
            default -> TEXTURE_0;
        };
    }
}

