/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.server.entity.misc.PlagueDoctor;
import com.github.alexthe666.rats.server.entity.monster.PiedPiper;
import com.github.alexthe666.rats.server.entity.monster.PlagueBeast;
import com.github.alexthe666.rats.server.entity.monster.PlagueCloud;
import com.github.alexthe666.rats.server.entity.monster.boss.BlackDeath;
import com.github.alexthe666.rats.server.entity.monster.boss.RatKing;
import com.github.alexthe666.rats.server.entity.mount.RatBeastMount;
import com.github.alexthe666.rats.server.entity.mount.RatChickenMount;
import com.github.alexthe666.rats.server.entity.mount.RatGolemMount;
import com.github.alexthe666.rats.server.entity.mount.RatStriderMount;
import com.github.alexthe666.rats.server.entity.projectile.PlagueShot;
import com.github.alexthe666.rats.server.entity.projectile.PurifyingLiquid;
import com.github.alexthe666.rats.server.entity.projectile.RatArrow;
import com.github.alexthe666.rats.server.entity.projectile.RatCaptureNet;
import com.github.alexthe666.rats.server.entity.projectile.RatDragonFire;
import com.github.alexthe666.rats.server.entity.projectile.RatShot;
import com.github.alexthe666.rats.server.entity.projectile.SmallArrow;
import com.github.alexthe666.rats.server.entity.projectile.ThrownBlock;
import com.github.alexthe666.rats.server.entity.rat.DemonRat;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RatsEntityRegistry {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"rats");
    public static final RegistryObject<EntityType<Rat>> RAT = RatsEntityRegistry.registerEntity("rat", EntityType.Builder.m_20704_(Rat::new, (MobCategory)RatsMod.RATS).m_20720_().m_20699_(0.49f, 0.49f), 0x30333E, 14330785);
    public static final RegistryObject<EntityType<TamedRat>> TAMED_RAT = RatsEntityRegistry.registerEntityNoEgg("tamed_rat", EntityType.Builder.m_20704_(TamedRat::new, (MobCategory)RatsMod.RATS).m_20699_(0.49f, 0.49f));
    public static final RegistryObject<EntityType<PiedPiper>> PIED_PIPER = RatsEntityRegistry.registerEntity("pied_piper", EntityType.Builder.m_20704_(PiedPiper::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.7f, 1.8f), 13286466, 3891299);
    public static final RegistryObject<EntityType<ThrownBlock>> THROWN_BLOCK = RatsEntityRegistry.registerEntityNoEgg("thrown_block", EntityType.Builder.m_20704_(ThrownBlock::new, (MobCategory)MobCategory.MISC).m_20699_(0.95f, 0.95f));
    public static final RegistryObject<EntityType<PlagueDoctor>> PLAGUE_DOCTOR = RatsEntityRegistry.registerEntity("plague_doctor", EntityType.Builder.m_20704_(PlagueDoctor::new, (MobCategory)MobCategory.CREATURE).m_20699_(0.8f, 1.8f), 0x2A292A, 5329753);
    public static final RegistryObject<EntityType<PurifyingLiquid>> PURIFYING_LIQUID = RatsEntityRegistry.registerEntityNoEgg("purifying_liquid", EntityType.Builder.m_20704_(PurifyingLiquid::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<BlackDeath>> BLACK_DEATH = RatsEntityRegistry.registerEntity("black_death", EntityType.Builder.m_20704_(BlackDeath::new, (MobCategory)MobCategory.MONSTER).m_20699_(0.6f, 2.1f).m_20719_(), 0, 0);
    public static final RegistryObject<EntityType<PlagueCloud>> PLAGUE_CLOUD = RatsEntityRegistry.registerEntity("plague_cloud", EntityType.Builder.m_20704_(PlagueCloud::new, (MobCategory)MobCategory.MONSTER).m_20719_().m_20699_(1.2f, 1.2f), 0, 5396301);
    public static final RegistryObject<EntityType<PlagueBeast>> PLAGUE_BEAST = RatsEntityRegistry.registerEntity("plague_beast", EntityType.Builder.m_20704_(PlagueBeast::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.85f, 1.2f), 0, 0xECECEC);
    public static final RegistryObject<EntityType<PlagueShot>> PLAGUE_SHOT = RatsEntityRegistry.registerEntityNoEgg("plague_shot", EntityType.Builder.m_20704_(PlagueShot::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatCaptureNet>> RAT_CAPTURE_NET = RatsEntityRegistry.registerEntityNoEgg("rat_capture_net", EntityType.Builder.m_20704_(RatCaptureNet::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatDragonFire>> RAT_DRAGON_FIRE = RatsEntityRegistry.registerEntityNoEgg("rat_dragon_fire", EntityType.Builder.m_20704_(RatDragonFire::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatArrow>> RAT_ARROW = RatsEntityRegistry.registerEntityNoEgg("rat_arrow", EntityType.Builder.m_20704_(RatArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<RatGolemMount>> RAT_MOUNT_GOLEM = RatsEntityRegistry.registerEntityNoEgg("rat_mount_golem", EntityType.Builder.m_20704_(RatGolemMount::new, (MobCategory)MobCategory.MISC).m_20699_(1.25f, 2.75f));
    public static final RegistryObject<EntityType<RatChickenMount>> RAT_MOUNT_CHICKEN = RatsEntityRegistry.registerEntityNoEgg("rat_mount_chicken", EntityType.Builder.m_20704_(RatChickenMount::new, (MobCategory)MobCategory.MISC).m_20699_(0.65f, 0.75f));
    public static final RegistryObject<EntityType<RatBeastMount>> RAT_MOUNT_BEAST = RatsEntityRegistry.registerEntityNoEgg("rat_mount_beast", EntityType.Builder.m_20704_(RatBeastMount::new, (MobCategory)MobCategory.MISC).m_20699_(1.85f, 1.2f));
    public static final RegistryObject<EntityType<RatKing>> RAT_KING = RatsEntityRegistry.registerEntity("rat_king", EntityType.Builder.m_20704_(RatKing::new, (MobCategory)MobCategory.MONSTER).m_20699_(2.0f, 0.5f), 0x30333E, 3748911);
    public static final RegistryObject<EntityType<RatShot>> RAT_SHOT = RatsEntityRegistry.registerEntityNoEgg("rat_shot", EntityType.Builder.m_20704_(RatShot::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f));
    public static final RegistryObject<EntityType<DemonRat>> DEMON_RAT = RatsEntityRegistry.registerEntity("demon_rat", EntityType.Builder.m_20704_(DemonRat::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.0f, 0.75f).m_20719_().m_20720_().m_20702_(8), 7084319, 16569600);
    public static final RegistryObject<EntityType<RatStriderMount>> RAT_STRIDER_MOUNT = RatsEntityRegistry.registerEntityNoEgg("rat_mount_strider", EntityType.Builder.m_20704_(RatStriderMount::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.9f, 1.7f).m_20702_(10));
    public static final RegistryObject<EntityType<SmallArrow>> SMALL_ARROW = RatsEntityRegistry.registerEntityNoEgg("small_arrow", EntityType.Builder.m_20704_(SmallArrow::new, (MobCategory)MobCategory.MISC).m_20699_(0.39f, 0.39f));

    private static <E extends Mob> RegistryObject<EntityType<E>> registerEntity(String entityName, EntityType.Builder<E> builder, int baseEggColor, int overlayEggColor) {
        ResourceLocation nameLoc = new ResourceLocation("rats", entityName);
        RegistryObject ret = ENTITIES.register(entityName, () -> builder.m_20712_(nameLoc.toString()));
        RatsItemRegistry.ITEMS.register(entityName + "_spawn_egg", () -> new ForgeSpawnEggItem((Supplier)ret, baseEggColor, overlayEggColor, new Item.Properties()));
        return ret;
    }

    private static <E extends Entity> RegistryObject<EntityType<E>> registerEntityNoEgg(String entityName, EntityType.Builder<E> builder) {
        return ENTITIES.register(entityName, () -> builder.m_20712_(new ResourceLocation("rats", entityName).toString()));
    }
}

