/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.registry.worldgen;

import com.github.alexthe666.rats.registry.worldgen.RatlantisBiomeRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisFeatureRegistry;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.OptionalLong;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarverDebugSettings;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class RatlantisDimensionRegistry {
    public static final ResourceLocation DIMENSION = new ResourceLocation("rats", "ratlantis");
    public static final ResourceKey<Level> DIMENSION_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DIMENSION);
    public static final ResourceKey<ConfiguredWorldCarver<?>> RATLANTIS_CAVES = ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)new ResourceLocation("rats", "ratlantis_caves"));
    public static final ResourceKey<NoiseGeneratorSettings> RATLANTIS_NOISE_GEN = ResourceKey.m_135785_((ResourceKey)Registries.f_256932_, (ResourceLocation)new ResourceLocation("rats", "ratlantis_noise_gen"));
    public static final ResourceKey<DimensionType> RATLANTIS_DIM_TYPE = ResourceKey.m_135785_((ResourceKey)Registries.f_256787_, (ResourceLocation)new ResourceLocation("rats", "ratlantis_type"));
    public static final ResourceKey<LevelStem> RATLANTIS_LEVEL_STEM = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)DIMENSION);
    private static final SurfaceRules.RuleSource BEDROCK = RatlantisDimensionRegistry.makeStateRule(Blocks.f_50752_);
    private static final SurfaceRules.RuleSource DIRT = RatlantisDimensionRegistry.makeStateRule(Blocks.f_50493_);
    private static final SurfaceRules.RuleSource GRASS_BLOCK = RatlantisDimensionRegistry.makeStateRule(Blocks.f_50440_);
    private static final SurfaceRules.RuleSource SAND = RatlantisDimensionRegistry.makeStateRule(Blocks.f_49992_);
    private static final SurfaceRules.RuleSource SANDSTONE = RatlantisDimensionRegistry.makeStateRule(Blocks.f_50062_);

    private static DimensionType ratlantisType() {
        return new DimensionType(OptionalLong.empty(), true, false, false, true, 1.0, true, false, 0, 256, 256, BlockTags.f_13058_, new ResourceLocation("overworld"), 0.0f, new DimensionType.MonsterSettings(false, false, (IntProvider)UniformInt.m_146622_((int)0, (int)7), 7));
    }

    public static NoiseGeneratorSettings ratlantisNoise(HolderGetter<DensityFunction> functions, HolderGetter<NormalNoise.NoiseParameters> noises) {
        DensityFunction densityfunction = NoiseRouterData.m_255403_(functions, (ResourceKey)NoiseRouterData.f_209448_);
        DensityFunction densityfunction1 = NoiseRouterData.m_255403_(functions, (ResourceKey)NoiseRouterData.f_209449_);
        return new NoiseGeneratorSettings(NoiseSettings.m_224525_((int)0, (int)256, (int)1, (int)2), Blocks.f_50069_.m_49966_(), Blocks.f_49990_.m_49966_(), new NoiseRouter(DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noises.m_255043_(Noises.f_189269_)), DensityFunctions.m_208296_((DensityFunction)densityfunction, (DensityFunction)densityfunction1, (double)0.25, (Holder)noises.m_255043_(Noises.f_189278_)), DensityFunctions.m_208263_(), DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208271_((long)0L)), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.234275), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)16, (int)32, (double)0.0, (double)1.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.234375), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-23.4375), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)0, (int)312, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)23.4375), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-0.703125), (DensityFunction)DensityFunctions.m_208373_((DensityFunction)DensityFunctions.m_208271_((long)0L))))))))), DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208264_((double)0.64), (DensityFunction)DensityFunctions.m_208281_((DensityFunction)DensityFunctions.m_208389_((DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)0.554375), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)0, (int)87, (double)0.25, (double)3.6), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.234375), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)-2.75), (DensityFunction)DensityFunctions.m_208363_((DensityFunction)DensityFunctions.m_208266_((int)0, (int)175, (double)1.0, (double)0.0), (DensityFunction)DensityFunctions.m_208293_((DensityFunction)DensityFunctions.m_208264_((double)1.75), (DensityFunction)new DensityFunctions.HolderHolder((Holder)functions.m_255043_(NoiseRouterData.f_224425_))))))))))).m_208234_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_(), DensityFunctions.m_208263_()), RatlantisDimensionRegistry.createSurfaceRules(), List.of(), 63, false, true, false, false);
    }

    public static void bootstrapNoise(BootstapContext<NoiseGeneratorSettings> context) {
        context.m_255272_(RATLANTIS_NOISE_GEN, (Object)RatlantisDimensionRegistry.ratlantisNoise((HolderGetter<DensityFunction>)context.m_255420_(Registries.f_257040_), (HolderGetter<NormalNoise.NoiseParameters>)context.m_255420_(Registries.f_256865_)));
    }

    public static void bootstrapType(BootstapContext<DimensionType> context) {
        context.m_255272_(RATLANTIS_DIM_TYPE, (Object)RatlantisDimensionRegistry.ratlantisType());
    }

    public static void bootstrapCarver(BootstapContext<ConfiguredWorldCarver<?>> context) {
        context.m_255272_(RATLANTIS_CAVES, (Object)((WorldCarver)RatlantisFeatureRegistry.RATLANTIS_CAVES.get()).m_65063_((CarverConfiguration)new CaveCarverConfiguration(0.15f, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158930_((int)8), (VerticalAnchor)VerticalAnchor.m_158922_((int)180)), (FloatProvider)UniformFloat.m_146605_((float)0.1f, (float)0.9f), VerticalAnchor.m_158921_(), CarverDebugSettings.m_159136_((boolean)false, (BlockState)Blocks.f_50669_.m_49966_()), (HolderSet)context.m_255420_(Registries.f_256747_).m_254956_(BlockTags.f_215820_), (FloatProvider)UniformFloat.m_146605_((float)0.7f, (float)1.4f), (FloatProvider)UniformFloat.m_146605_((float)0.8f, (float)1.3f), (FloatProvider)UniformFloat.m_146605_((float)-1.0f, (float)-0.4f))));
    }

    public static void bootstrapLevelStem(BootstapContext<LevelStem> context) {
        HolderGetter biomeRegistry = context.m_255420_(Registries.f_256952_);
        HolderGetter dimTypes = context.m_255420_(Registries.f_256787_);
        HolderGetter noiseGenSettings = context.m_255420_(Registries.f_256932_);
        context.m_255272_(RATLANTIS_LEVEL_STEM, (Object)new LevelStem((Holder)dimTypes.m_255043_(RATLANTIS_DIM_TYPE), (ChunkGenerator)new NoiseBasedChunkGenerator(RatlantisBiomeRegistry.buildBiomeSource((HolderGetter<Biome>)biomeRegistry), (Holder)noiseGenSettings.m_255043_(RATLANTIS_NOISE_GEN))));
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.m_189390_((BlockState)block.m_49966_());
    }

    private static SurfaceRules.RuleSource createSurfaceRules() {
        SurfaceRules.RuleSource overworldLike = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189375_, (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189377_, (SurfaceRules.RuleSource)SANDSTONE), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)GRASS_BLOCK), SAND}), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189382_((int)-1, (int)0), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{GRASS_BLOCK}))})), SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189419_((int)-6, (int)-1), (SurfaceRules.RuleSource)SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.f_189376_, (SurfaceRules.RuleSource)DIRT)}))});
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)SurfaceRules.m_189394_((SurfaceRules.ConditionSource)SurfaceRules.m_189403_((String)"bedrock_floor", (VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158930_((int)5)), (SurfaceRules.RuleSource)BEDROCK));
        builder.add((Object)overworldLike);
        return SurfaceRules.m_198272_((SurfaceRules.RuleSource[])((SurfaceRules.RuleSource[])builder.build().toArray(SurfaceRules.RuleSource[]::new)));
    }
}

