/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.monster.PiedPiper;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGarbageBlock
extends FallingBlock {
    public final MobSpawnType spawnReason = MobSpawnType.SPAWNER;
    public final double spawnRateModifier;

    public AbstractGarbageBlock(BlockBehaviour.Properties properties, double spawnRateModifier) {
        super(properties);
        this.spawnRateModifier = spawnRateModifier;
    }

    protected abstract EntityType<? extends PathfinderMob> getEntityToSpawn();

    protected void postInitSpawn(PathfinderMob mob, RandomSource random) {
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (random.m_188503_(((GameRules.IntegerValue)level.m_46469_().m_46170_(GameRules.f_46143_)).m_46288_()) <= 3 && !level.m_8055_(pos.m_7494_()).m_60828_((BlockGetter)level, pos) && level.m_46469_().m_46207_(GameRules.f_46134_) && (double)random.m_188501_() <= RatConfig.garbageSpawnRate * this.spawnRateModifier) {
            PathfinderMob mob = (PathfinderMob)this.getEntityToSpawn().m_20615_((Level)level);
            if (mob == null) {
                return;
            }
            mob.m_7678_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 0.0f, 0.0f);
            if (!mob.m_5545_((LevelAccessor)level, this.spawnReason)) {
                return;
            }
            if (!mob.m_5830_() && mob.m_6914_((LevelReader)level)) {
                if (mob instanceof AbstractRat) {
                    if (!level.m_46469_().m_46207_(RatsMod.SPAWN_RATS)) {
                        return;
                    }
                    if (Objects.requireNonNull(level.m_7726_().m_8485_()).m_47148_().getInt((Object)RatsMod.RATS) >= RatsMod.RATS.m_21608_() * 2) {
                        return;
                    }
                    if (RatConfig.ratsSpawnLikeMonsters && !this.isDarkEnoughForMonsterSpawns((ServerLevelAccessor)level, mob.m_20183_(), random)) {
                        return;
                    }
                    ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(pos), (MobSpawnType)this.spawnReason, null, null);
                    this.postInitSpawn(mob, random);
                    level.m_8860_((Entity)mob);
                } else {
                    if (mob instanceof PiedPiper && !level.m_46469_().m_46207_(RatsMod.SPAWN_PIPERS)) {
                        return;
                    }
                    if (this.isDarkEnoughForMonsterSpawns((ServerLevelAccessor)level, mob.m_20183_(), random)) {
                        ForgeEventFactory.onFinalizeSpawn((Mob)mob, (ServerLevelAccessor)level, (DifficultyInstance)level.m_6436_(pos), (MobSpawnType)this.spawnReason, null, null);
                        this.postInitSpawn(mob, random);
                        level.m_8860_((Entity)mob);
                    }
                }
            }
        }
    }

    private boolean isDarkEnoughForMonsterSpawns(ServerLevelAccessor accessor, BlockPos pos, RandomSource random) {
        DimensionType dimensiontype = accessor.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && accessor.m_45517_(LightLayer.BLOCK, pos) > i) {
            return false;
        }
        int j = accessor.m_6018_().m_46470_() ? accessor.m_46849_(pos, 10) : accessor.m_46803_(pos);
        return j <= dimensiontype.m_223569_().m_214085_(random);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)(this.m_7705_() + ".desc")).m_130940_(ChatFormatting.GRAY));
    }

    public boolean isValidSpawn(BlockState state, BlockGetter level, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return entityType == this.getEntityToSpawn();
    }
}

