/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.block.entity.RatTrapBlockEntity;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RatTrapBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty SHUT = BooleanProperty.m_61465_((String)"shut");
    private static final VoxelShape NS_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)1.0, (double)12.0, (double)2.0, (double)15.0);
    private static final VoxelShape EW_AABB = Block.m_49796_((double)1.0, (double)0.0, (double)4.0, (double)15.0, (double)2.0, (double)12.0);

    public RatTrapBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHUT, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.Z ? NS_AABB : EW_AABB;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor accessor, BlockPos pos, BlockPos newPos) {
        return !state.m_60710_((LevelReader)accessor, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, newState, accessor, pos, newPos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!newState.m_60713_(state.m_60734_())) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof RatTrapBlockEntity) {
                RatTrapBlockEntity trap = (RatTrapBlockEntity)blockEntity;
                if (!level.m_5776_() && !trap.getBait().m_41619_()) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), trap.getBait()));
                }
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        if (level.m_276867_(pos) && ((Boolean)state.m_61143_((Property)SHUT)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SHUT, (Comparable)Boolean.valueOf(false)));
            level.m_7260_(pos, state, state, 3);
            level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.RAT_TRAP_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
    }

    public boolean m_7898_(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)reader, pos.m_7495_(), Direction.UP);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHUT});
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemstack = player.m_21120_(hand);
        BlockEntity be = level.m_7702_(pos);
        if (((Boolean)state.m_61143_((Property)SHUT)).booleanValue()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SHUT, (Comparable)Boolean.valueOf(false)));
            level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.RAT_TRAP_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (be instanceof RatTrapBlockEntity) {
            RatTrapBlockEntity ratTrap = (RatTrapBlockEntity)be;
            if (ratTrap.getBait().m_41619_() && RatUtils.isRatFood(itemstack)) {
                ratTrap.setBaitStack(itemstack.m_41777_());
                level.m_7260_(pos, state, state, 3);
                itemstack.m_41764_(0);
                level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.RAT_TRAP_ADD_BAIT.get(), SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                return InteractionResult.SUCCESS;
            }
            if (!ratTrap.getBait().m_41619_() && !((Boolean)state.m_61143_((Property)SHUT)).booleanValue() && player.m_6144_()) {
                if (!level.m_5776_()) {
                    level.m_7967_((Entity)new ItemEntity(level, (double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f), ratTrap.getBait()));
                }
                ratTrap.setBaitStack(ItemStack.f_41583_);
                level.m_7260_(pos, state, state, 3);
                level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.RAT_TRAP_REMOVE_BAIT.get(), SoundSource.BLOCKS, 1.0f, (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)SHUT) != false ? 15 : 0;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RatTrapBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RatTrapBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatsBlockEntityRegistry.RAT_TRAP.get()), RatTrapBlockEntity::tick);
    }
}

