/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatlantisBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.worldgen.RatlantisDimensionRegistry;
import com.github.alexthe666.rats.server.block.CustomItemRarity;
import com.github.alexthe666.rats.server.block.WearableOnHead;
import com.github.alexthe666.rats.server.block.entity.RatlanteanAutomatonHeadBlockEntity;
import com.github.alexthe666.rats.server.entity.monster.boss.RatlanteanAutomaton;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RatlanteanAutomatonHeadBlock
extends BaseEntityBlock
implements WearableOnHead,
CustomItemRarity {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final Map<Direction, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.m_49796_((double)4.0, (double)5.0, (double)0.0, (double)12.0, (double)14.0, (double)10.0), (Object)Direction.EAST, (Object)Block.m_49796_((double)6.0, (double)5.0, (double)4.0, (double)16.0, (double)14.0, (double)12.0), (Object)Direction.SOUTH, (Object)Block.m_49796_((double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)14.0, (double)16.0), (Object)Direction.WEST, (Object)Block.m_49796_((double)0.0, (double)5.0, (double)4.0, (double)10.0, (double)14.0, (double)12.0)));
    private static final Predicate<BlockState> IS_MARBLE = state -> state != null && state.m_204336_(RatsBlockTags.MARBLED_CHEESE);
    private static BlockPattern golemBasePattern;
    private static BlockPattern golemPattern;

    public RatlanteanAutomatonHeadBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.m_61143_((Property)FACING));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    @Override
    public Rarity getRarity() {
        return RatsMod.RATLANTIS_SPECIAL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean moving) {
        if (oldState.m_60734_() != state.m_60734_()) {
            RatlanteanAutomatonHeadBlock.trySpawnGolem(level, pos);
        }
    }

    public static boolean canSpawnGolem(Level level, BlockPos pos) {
        if (pos.m_123342_() >= level.m_141937_() + 2 && level.m_46791_() != Difficulty.PEACEFUL && !level.m_5776_()) {
            return RatlanteanAutomatonHeadBlock.getGolemBasePattern().m_61184_((LevelReader)level, pos) != null;
        }
        return false;
    }

    public static void trySpawnGolem(Level level, BlockPos pos) {
        if (level.m_6436_(pos).m_19048_() == Difficulty.PEACEFUL) {
            return;
        }
        if (RatConfig.summonAutomatonOnlyInRatlantis && !level.m_46472_().equals(RatlantisDimensionRegistry.DIMENSION_KEY)) {
            for (Player player : level.m_45976_(Player.class, new AABB(pos).m_82400_(16.0))) {
                player.m_5661_((Component)Component.m_237115_((String)"entity.rats.ratlantean_automaton.ratlantis"), true);
            }
            return;
        }
        BlockPattern.BlockPatternMatch matcher = RatlanteanAutomatonHeadBlock.getGolemPattern().m_61184_((LevelReader)level, pos);
        if (matcher != null) {
            for (int j = 0; j < RatlanteanAutomatonHeadBlock.getGolemPattern().m_61203_(); ++j) {
                for (int k = 0; k < RatlanteanAutomatonHeadBlock.getGolemPattern().m_61202_(); ++k) {
                    if (matcher.m_61229_(j, k, 0).m_61168_().m_247087_()) continue;
                    level.m_7731_(matcher.m_61229_(j, k, 0).m_61176_(), Blocks.f_50016_.m_49966_(), 2);
                }
            }
            BlockPos blockpos = matcher.m_61229_(1, 2, 0).m_61176_();
            RatlanteanAutomaton automaton = new RatlanteanAutomaton((EntityType<? extends Monster>)((EntityType)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON.get()), level);
            automaton.m_7678_((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.05, (double)blockpos.m_123343_() + 0.5, 0.0f, 0.0f);
            level.m_7967_((Entity)automaton);
            for (ServerPlayer player : level.m_45976_(ServerPlayer.class, automaton.m_20191_().m_82400_(5.0))) {
                CriteriaTriggers.f_10580_.m_68256_(player, (Entity)automaton);
            }
            for (int i1 = 0; i1 < RatlanteanAutomatonHeadBlock.getGolemPattern().m_61203_(); ++i1) {
                for (int j1 = 0; j1 < RatlanteanAutomatonHeadBlock.getGolemPattern().m_61202_(); ++j1) {
                    BlockInWorld block = matcher.m_61229_(i1, j1, 0);
                    level.m_7260_(block.m_61176_(), block.m_61168_(), block.m_61168_(), 4);
                }
            }
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    protected static BlockPattern getGolemBasePattern() {
        if (golemBasePattern == null) {
            golemBasePattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~ ~", "#X#", "~#~"}).m_61244_('#', BlockInWorld.m_61169_(IS_MARBLE)).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_247087_)).m_61244_('X', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE.get())))).m_61249_();
        }
        return golemBasePattern;
    }

    protected static BlockPattern getGolemPattern() {
        if (golemPattern == null) {
            golemPattern = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"~^~", "#X#", "~#~"}).m_61244_('^', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_RAT_HEAD.get())))).m_61244_('#', BlockInWorld.m_61169_(IS_MARBLE)).m_61244_('~', BlockInWorld.m_61169_(BlockBehaviour.BlockStateBase::m_247087_)).m_61244_('X', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)RatlantisBlockRegistry.MARBLED_CHEESE_GOLEM_CORE.get())))).m_61249_();
        }
        return golemPattern;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new RatlanteanAutomatonHeadBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return RatlanteanAutomatonHeadBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatlantisBlockEntityRegistry.AUTOMATON_HEAD.get()), RatlanteanAutomatonHeadBlockEntity::tick);
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }
}

