/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block;

import com.github.alexthe666.rats.data.tags.RatsBlockTags;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.block.entity.TrashCanBlockEntity;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class TrashCanBlock
extends BaseEntityBlock
implements WorldlyContainerHolder {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)7);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    private static final VoxelShape OUTER_SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0);
    private static final VoxelShape INNER_SHAPE = Block.m_49796_((double)1.1, (double)1.0, (double)1.1, (double)14.9, (double)18.0, (double)14.9);
    private static final VoxelShape COLLISION_SHAPE_OUTER = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)18.0, (double)15.0);
    private static final VoxelShape COLLISION_SHAPE_INNER = Block.m_49796_((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)18.0, (double)13.0);
    private static final VoxelShape LID = Block.m_49796_((double)0.0, (double)18.0, (double)0.0, (double)16.0, (double)20.0, (double)16.0);
    private static final VoxelShape CLOSED_SHAPE = Shapes.m_83110_((VoxelShape)OUTER_SHAPE, (VoxelShape)LID).m_83296_();

    public TrashCanBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? Shapes.m_83113_((VoxelShape)OUTER_SHAPE, (VoxelShape)INNER_SHAPE, (BooleanOp)BooleanOp.f_82685_) : CLOSED_SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        EntityCollisionContext ctx;
        return context instanceof EntityCollisionContext && (ctx = (EntityCollisionContext)context).m_193113_() != null ? (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() ? Shapes.m_83113_((VoxelShape)COLLISION_SHAPE_OUTER, (VoxelShape)COLLISION_SHAPE_INNER, (BooleanOp)BooleanOp.f_82685_) : CLOSED_SHAPE) : state.m_60651_(getter, pos, context);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return (Boolean)state.m_61143_((Property)OPEN) != false ? OUTER_SHAPE : CLOSED_SHAPE;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.m_60713_(newState.m_60734_()) && (Integer)state.m_61143_((Property)LEVEL) == 7 && !level.m_5776_()) {
            ItemEntity item = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get()));
            item.m_32060_();
            level.m_7967_((Entity)item);
        }
        super.m_6810_(state, level, pos, newState, moving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        BlockEntity te = level.m_7702_(pos);
        if (!player.m_6047_() && ((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            Item item2;
            if ((Integer)state.m_61143_((Property)LEVEL) == 7) {
                if (!level.m_5776_()) {
                    ItemEntity item2 = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.75, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get()));
                    item2.m_32060_();
                    level.m_7967_((Entity)item2);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
                level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.TRASH_CAN_EMPTY.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            if ((Integer)state.m_61143_((Property)LEVEL) < 7 && (item2 = stack.m_41720_()) instanceof BlockItem) {
                BlockItem bi = (BlockItem)item2;
                if (Objects.requireNonNull(ForgeRegistries.BLOCKS.tags()).getTag(RatsBlockTags.TRASH_CAN_BLACKLIST).contains((Object)bi.m_40614_())) {
                    player.m_5661_((Component)Component.m_237113_((String)"This block can't be used here.").m_130940_(ChatFormatting.RED), true);
                    return InteractionResult.CONSUME;
                }
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)LEVEL) + 1)));
                for (int i = 0; i < 100; ++i) {
                    level.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)RatsBlockRegistry.GARBAGE_PILE.get()).m_49966_()), (double)pos.m_123341_() + 0.4 + level.m_213780_().m_188500_() * 0.2, (double)pos.m_123342_() + ((double)((Integer)state.m_61143_((Property)LEVEL) * 2) - 1.0) * 0.1, (double)pos.m_123343_() + 0.4 + level.m_213780_().m_188500_() * 0.2, 0.0, 0.0, 0.0);
                }
                level.m_5594_(null, pos, (SoundEvent)RatsSoundRegistry.TRASH_CAN_FILL.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        if ((player.m_6047_() || stack.m_41619_()) && te instanceof TrashCanBlockEntity) {
            TrashCanBlockEntity trashCan = (TrashCanBlockEntity)te;
            if (trashCan.lidProgress == 0.0f || trashCan.lidProgress == 20.0f) {
                level.m_5594_(player, pos, (SoundEvent)RatsSoundRegistry.TRASH_CAN.get(), SoundSource.BLOCKS, 0.5f, 0.75f + level.m_213780_().m_188501_() * 0.5f);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)OPEN) == false)));
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)OPEN)).booleanValue() && (Integer)state.m_61143_((Property)LEVEL) > 0 && random.m_188501_() <= (float)((Integer)state.m_61143_((Property)LEVEL)).intValue() * 0.0025f) {
            double d0 = (float)pos.m_123341_() + random.m_188501_();
            double d1 = (double)pos.m_123342_() + 1.0 + (double)random.m_188501_();
            double d2 = (float)pos.m_123343_() + random.m_188501_();
            level.m_7106_((ParticleOptions)RatsParticleRegistry.FLY.get(), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"block.rats.trash_can.desc0").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"block.rats.trash_can.desc1").m_130940_(ChatFormatting.GRAY));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7357_(BlockState state, BlockGetter getter, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, LEVEL});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TrashCanBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return TrashCanBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RatsBlockEntityRegistry.TRASH_CAN.get()), TrashCanBlockEntity::tick);
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor accessor, BlockPos pos) {
        return (Integer)state.m_61143_((Property)LEVEL) == 7 ? new OutputContainer(state, accessor, pos, new ItemStack((ItemLike)RatsBlockRegistry.GARBAGE_PILE.get())) : new InputContainer(state, accessor, pos);
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState state, LevelAccessor accessor, BlockPos pos, ItemStack stack) {
            super(new ItemStack[]{stack});
            this.state = state;
            this.level = accessor;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction direction) {
            int[] nArray;
            if (direction == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int amount, ItemStack stack, @Nullable Direction direction) {
            return false;
        }

        public boolean m_7157_(int amount, ItemStack stack, Direction direction) {
            return !this.changed && direction == Direction.DOWN;
        }

        public void m_6596_() {
            this.level.m_7731_(this.pos, (BlockState)this.state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
            this.changed = true;
        }
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState state, LevelAccessor accessor, BlockPos pos) {
            super(1);
            this.state = state;
            this.level = accessor;
            this.pos = pos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction direction) {
            int[] nArray;
            if (direction != Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int amount, ItemStack stack, @Nullable Direction direction) {
            return !this.changed && (Boolean)this.state.m_61143_((Property)OPEN) != false && direction != Direction.DOWN && stack.m_41720_() instanceof BlockItem;
        }

        public boolean m_7157_(int amount, ItemStack stack, Direction direction) {
            return false;
        }

        public void m_6596_() {
            ItemStack itemstack = this.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.changed = true;
                this.level.m_7731_(this.pos, (BlockState)this.state.m_61122_((Property)LEVEL), 3);
                this.m_8016_(0);
            }
        }
    }
}

