/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.registry.RatsBlockRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.inventory.AutoCurdlerMenu;
import com.github.alexthe666.rats.server.message.RatsNetworkHandler;
import com.github.alexthe666.rats.server.message.UpdateCurdlerFluidPacket;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class AutoCurdlerBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{1};
    private final FluidTank tank = new FluidTank(5000, fluidStack -> fluidStack.getFluid().m_6212_((Fluid)ForgeMod.MILK.get()));
    final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN});
    private final LazyOptional<IFluidHandler> holder = LazyOptional.of(() -> this.tank);
    private NonNullList<ItemStack> curdlerStacks = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    public int cookTime;
    public int totalCookTime;
    public final ContainerData data = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> AutoCurdlerBlockEntity.this.cookTime;
                case 1 -> AutoCurdlerBlockEntity.this.totalCookTime;
                case 2 -> AutoCurdlerBlockEntity.this.tank.getFluidAmount();
                case 3 -> AutoCurdlerBlockEntity.this.tank.getCapacity();
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    AutoCurdlerBlockEntity.this.cookTime = value;
                    break;
                }
                case 1: {
                    AutoCurdlerBlockEntity.this.totalCookTime = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };

    public AutoCurdlerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.AUTO_CURDLER.get(), pos, state);
    }

    public static boolean isMilk(ItemStack stack) {
        if (stack.m_150930_(Items.f_42455_)) {
            return true;
        }
        Optional fluidStack = FluidUtil.getFluidContained((ItemStack)stack);
        return fluidStack.isPresent() && ((FluidStack)fluidStack.get()).getFluid().m_6212_((Fluid)ForgeMod.MILK.get());
    }

    public int m_6643_() {
        return this.curdlerStacks.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.curdlerStacks) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.curdlerStacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.curdlerStacks, (int)index, (int)count);
    }

    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.curdlerStacks, (int)index);
    }

    public void m_6836_(int index, ItemStack stack) {
        this.curdlerStacks.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.tank.readFromNBT(compound);
        this.curdlerStacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)compound, this.curdlerStacks);
        this.cookTime = compound.m_128451_("CookTime");
        this.totalCookTime = compound.m_128451_("CookTimeTotal");
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.tank.writeToNBT(compound);
        compound.m_128405_("CookTime", (int)((short)this.cookTime));
        compound.m_128405_("CookTimeTotal", (int)((short)this.totalCookTime));
        ContainerHelper.m_18973_((CompoundTag)compound, this.curdlerStacks);
    }

    public boolean m_6542_(Player player) {
        if (this.m_58904_() != null) {
            if (this.m_58904_().m_7702_(this.m_58899_()) != this) {
                return false;
            }
            return !(player.m_20275_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5) > 64.0);
        }
        return true;
    }

    public boolean hasEnoughMilk() {
        return this.tank.getFluidAmount() >= 1000 && this.isMilkFluid(this.tank.getFluid());
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AutoCurdlerBlockEntity te) {
        if (!level.m_5776_()) {
            te.totalCookTime = RatConfig.milkCauldronTime;
            if (te.hasEnoughMilk()) {
                if (te.canMakeCheese()) {
                    ++te.cookTime;
                    if (te.cookTime == te.totalCookTime) {
                        te.cookTime = 0;
                        te.totalCookTime = RatConfig.milkCauldronTime;
                        te.makeCheese(level);
                    }
                } else {
                    te.cookTime = 0;
                }
            } else if (!te.hasEnoughMilk() && te.cookTime > 0) {
                te.cookTime = Mth.m_14045_((int)(te.cookTime - 2), (int)0, (int)te.totalCookTime);
            }
            if (AutoCurdlerBlockEntity.isMilk(te.m_8020_(0))) {
                Optional fluidStackOptional = FluidUtil.getFluidContained((ItemStack)te.m_8020_(0));
                fluidStackOptional.ifPresent(fluidStack -> {
                    LazyOptional fluidHandlerOptional = FluidUtil.getFluidHandler((ItemStack)te.m_8020_(0));
                    fluidHandlerOptional.ifPresent(fluidHandler -> {
                        if (fluidHandler.drain(te.tank.getCapacity() - te.tank.getFluidAmount(), IFluidHandler.FluidAction.SIMULATE).getAmount() > 0) {
                            if (te.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.SIMULATE) != 0) {
                                int amount = te.tank.fill(fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE);
                                fluidHandler.drain(amount, IFluidHandler.FluidAction.EXECUTE);
                                ItemStack container = fluidHandler.getContainer();
                                if (te.m_8020_(0) != container) {
                                    te.m_6836_(0, container);
                                }
                            }
                            te.m_6596_();
                        }
                    });
                });
            }
        }
    }

    public void makeCheese(Level level) {
        if (this.canMakeCheese()) {
            ItemStack toAdd = new ItemStack((ItemLike)RatsBlockRegistry.BLOCK_OF_CHEESE.get());
            if (this.m_8020_(1).m_150930_(toAdd.m_41720_()) && this.m_8020_(1).m_41613_() < 64) {
                this.m_8020_(1).m_41769_(1);
            } else if (this.m_8020_(1).m_41619_()) {
                this.m_6836_(1, toAdd.m_41777_());
            }
            this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            level.m_5594_(null, this.m_58899_(), (SoundEvent)RatsSoundRegistry.CHEESE_MADE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            for (int i = 0; i < 10; ++i) {
                ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)RatsParticleRegistry.MILK_BUBBLE.get()), (double)((float)this.m_58899_().m_123341_() + 0.25f + level.m_213780_().m_188501_() * 0.5f), (double)((float)this.m_58899_().m_123342_() + 0.55f + (float)this.tank.getFluidAmount() * 1.0E-4f), (double)((float)this.m_58899_().m_123343_() + 0.25f + level.m_213780_().m_188501_() * 0.5f), 1, 0.0, 0.0, 0.0, 0.0);
            }
            this.m_6596_();
        }
    }

    public boolean canMakeCheese() {
        if (this.tank.getFluidAmount() < 1000) {
            return false;
        }
        ItemStack itemstack = new ItemStack((ItemLike)RatsBlockRegistry.BLOCK_OF_CHEESE.get());
        if (itemstack.m_41619_()) {
            return false;
        }
        ItemStack itemstack1 = this.m_8020_(1);
        if (itemstack1.m_41619_()) {
            return true;
        }
        if (!itemstack1.m_150930_(itemstack.m_41720_())) {
            return false;
        }
        if (itemstack1.m_41613_() + itemstack.m_41613_() <= this.m_6893_() && itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack1.m_41741_()) {
            return true;
        }
        return itemstack1.m_41613_() + itemstack.m_41613_() <= itemstack.m_41741_();
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.m_58904_() != null && !this.m_58904_().m_5776_()) {
            RatsNetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateCurdlerFluidPacket(this.m_58899_().m_121878_(), this.tank.getFluid()));
        }
    }

    public boolean m_7013_(int index, ItemStack stack) {
        if (index == 1) {
            return false;
        }
        return AutoCurdlerBlockEntity.isMilk(stack);
    }

    private boolean isMilkFluid(FluidStack fluid) {
        return fluid.getTranslationKey().contains("milk") || fluid.getTranslationKey().contains("Milk");
    }

    public void m_6211_() {
        this.curdlerStacks.clear();
    }

    public FluidTank getTank() {
        return this.tank;
    }

    public int[] m_7071_(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_BOTTOM;
        }
        return SLOTS_TOP;
    }

    public boolean m_7155_(int index, ItemStack stack, @Nullable Direction direction) {
        return this.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && index == 1;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.rats.auto_curdler");
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[0].cast();
        }
        if (capability == ForgeCapabilities.FLUID_HANDLER) {
            return this.holder.cast();
        }
        return LazyOptional.empty();
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory inventory) {
        return new AutoCurdlerMenu(id, (Container)this, inventory, this.data);
    }
}

