/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.block.entity;

import com.github.alexthe666.rats.registry.RatsBlockEntityRegistry;
import com.github.alexthe666.rats.server.block.RatTubeBlock;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RatTubeBlockEntity
extends BlockEntity {
    private static final BooleanProperty[] allOpenVars = new BooleanProperty[]{RatTubeBlock.OPEN_DOWN, RatTubeBlock.OPEN_EAST, RatTubeBlock.OPEN_NORTH, RatTubeBlock.OPEN_SOUTH, RatTubeBlock.OPEN_UP, RatTubeBlock.OPEN_WEST};
    public Direction opening = null;
    public boolean isNode = false;
    private int color;

    public RatTubeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)RatsBlockEntityRegistry.RAT_TUBE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, RatTubeBlockEntity te) {
        if (te.isOpen()) {
            float i = (float)pos.m_123341_() + 0.5f;
            float j = (float)pos.m_123342_() + 0.2f;
            float k = (float)pos.m_123343_() + 0.5f;
            float d0 = 0.4f;
            for (Rat rat : level.m_45976_(Rat.class, new AABB((double)i - (double)d0, (double)j - (double)d0, (double)k - (double)d0, (double)i + (double)d0, (double)j + (double)d0, (double)k + (double)d0))) {
                rat.m_7601_(state, new Vec3(1.75, 1.0, 1.75));
                te.updateRat(rat);
            }
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, BlockEntity::m_5995_);
    }

    public CompoundTag m_5995_() {
        return this.m_187481_();
    }

    private void updateRat(Rat rat) {
    }

    private boolean isOpen() {
        BlockState state = Objects.requireNonNull(this.m_58904_()).m_8055_(this.m_58899_());
        if (state.m_60734_() instanceof RatTubeBlock) {
            for (BooleanProperty opened : allOpenVars) {
                if (!((Boolean)state.m_61143_((Property)opened)).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public void m_183515_(CompoundTag compound) {
        compound.m_128379_("RatNode", this.isNode);
        compound.m_128405_("OpenSide", this.opening == null ? -1 : this.opening.ordinal());
        compound.m_128405_("TubeColor", this.color);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.isNode = compound.m_128471_("RatNode");
        int i = compound.m_128451_("OpenSide");
        this.opening = i == -1 ? null : Direction.values()[Mth.m_14045_((int)i, (int)0, (int)(Direction.values().length - 1))];
        this.color = compound.m_128451_("TubeColor");
    }

    public void setEntranceData(Direction side, boolean open) {
        if (open) {
            this.opening = side;
            this.isNode = true;
        } else {
            this.opening = null;
            this.isNode = false;
        }
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int colorIn) {
        this.color = colorIn;
    }
}

