/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;

public class RatBottlerGoal
extends BaseRatHarvestGoal {
    public RatBottlerGoal(TamedRat rat) {
        super(rat);
    }

    @Override
    public boolean m_8036_() {
        if (!(super.m_8036_() && this.checkTheBasics(false, false) && this.rat.m_21205_().m_150930_(Items.f_42590_))) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    public boolean m_8045_() {
        return this.getTargetBlock() != null && this.rat.m_21205_().m_150930_(Items.f_42590_);
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null) {
            BlockPos pos = this.getTargetBlock();
            BlockState block = this.rat.m_9236_().m_8055_(pos);
            this.rat.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.25);
            double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
            if (distance < this.rat.getRatHarvestDistance(0.0)) {
                if (block.m_60734_() instanceof BeehiveBlock) {
                    this.giveOrDropItem(new ItemStack((ItemLike)Items.f_42787_));
                    this.rat.m_9236_().m_5594_(null, this.rat.m_20183_(), SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    if (!CampfireBlock.m_51248_((Level)this.rat.m_9236_(), (BlockPos)pos)) {
                        if (this.hiveContainsBees(this.rat.m_9236_(), pos)) {
                            this.angerNearbyBees(this.rat.m_9236_(), pos);
                        }
                        this.releaseBeesAndResetHoneyLevel(this.rat.m_9236_(), block, pos, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
                    } else {
                        this.rat.m_9236_().m_7731_(pos, (BlockState)block.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
                    }
                    this.m_8041_();
                } else if (block.m_60713_(Blocks.f_152476_)) {
                    LayeredCauldronBlock.m_153559_((BlockState)block, (Level)this.rat.m_9236_(), (BlockPos)pos);
                    this.giveOrDropItem(PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_));
                    this.rat.m_9236_().m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.m_8041_();
                }
            }
        }
    }

    private void angerNearbyBees(Level level, BlockPos pos) {
        List list = level.m_45976_(Bee.class, new AABB(pos).m_82377_(8.0, 6.0, 8.0));
        if (!list.isEmpty()) {
            for (Bee bee : list) {
                if (bee.m_5448_() != null) continue;
                bee.m_6710_((LivingEntity)this.rat);
            }
        }
    }

    private boolean hiveContainsBees(Level level, BlockPos pos) {
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehiveblockentity = (BeehiveBlockEntity)blockentity;
            return !beehiveblockentity.m_58774_();
        }
        return false;
    }

    public void releaseBeesAndResetHoneyLevel(Level level, BlockState state, BlockPos pos, BeehiveBlockEntity.BeeReleaseStatus status) {
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)BeehiveBlock.f_49564_, (Comparable)Integer.valueOf(0)), 3);
        BlockEntity blockentity = level.m_7702_(pos);
        if (blockentity instanceof BeehiveBlockEntity) {
            BeehiveBlockEntity beehive = (BeehiveBlockEntity)blockentity;
            List list = beehive.m_58759_(state, status);
            for (Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee bee = (Bee)entity;
                if (!(this.rat.m_20182_().m_82557_(entity.m_20182_()) <= 16.0)) continue;
                if (!beehive.m_58777_()) {
                    bee.m_6710_((LivingEntity)this.rat);
                    continue;
                }
                bee.m_27915_(400);
            }
        }
    }

    private void giveOrDropItem(ItemStack stack) {
        this.rat.m_21205_().m_41774_(1);
        if (this.rat.m_21205_().m_41619_()) {
            this.rat.m_21008_(InteractionHand.MAIN_HAND, stack);
        } else {
            this.rat.m_19983_(stack);
        }
        this.rat.m_146850_(GameEvent.f_157816_);
    }

    private void resetTarget() {
        ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
        int RADIUS = this.rat.getRadius();
        for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
            BlockState state = this.rat.m_9236_().m_8055_(pos);
            if (state.m_60734_() instanceof BeehiveBlock && (Integer)state.m_61143_((Property)BeehiveBlock.f_49564_) == 5) {
                allBlocks.add(pos);
                continue;
            }
            if (!state.m_60713_(Blocks.f_152476_) || (Integer)state.m_61143_((Property)LayeredCauldronBlock.f_153514_) <= 0) continue;
            allBlocks.add(pos);
        }
        if (!allBlocks.isEmpty()) {
            allBlocks.sort(this.getTargetSorter());
            this.setTargetBlock((BlockPos)allBlocks.get(0));
        }
    }
}

