/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.ai.goal.harvest;

import com.github.alexthe666.rats.server.entity.ai.goal.harvest.BaseRatHarvestGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.RatUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;

public class RatFarmGoal
extends BaseRatHarvestGoal {
    private final TamedRat rat;

    public RatFarmGoal(TamedRat rat) {
        super(rat);
        this.rat = rat;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || !this.checkTheBasics(this.rat.getDepositPos().isPresent(), false) || !this.holdingSeeds() && !this.holdingBonemeal()) {
            return false;
        }
        this.resetTarget();
        return this.getTargetBlock() != null;
    }

    private boolean holdingSeeds() {
        ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
        return !stack.m_41619_() && stack.m_204117_(Tags.Items.SEEDS);
    }

    private boolean holdingBonemeal() {
        ItemStack stack = this.rat.m_21120_(InteractionHand.MAIN_HAND);
        return !stack.m_41619_() && stack.m_150930_(Items.f_42499_);
    }

    public boolean m_8045_() {
        return this.checkTheBasics(false, false) && this.getTargetBlock() != null && (this.holdingSeeds() || this.holdingBonemeal());
    }

    public void m_8037_() {
        if (this.getTargetBlock() != null) {
            if (this.holdingSeeds()) {
                BlockState block = this.rat.m_9236_().m_8055_(this.getTargetBlock());
                this.rat.m_21573_().m_26519_((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_() + 0.5, 1.25);
                if (block.m_60734_().isFertile(block, (BlockGetter)this.rat.m_9236_(), this.getTargetBlock()) && this.rat.m_9236_().m_46859_(this.getTargetBlock().m_7494_())) {
                    double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
                    if (distance < this.rat.getRatHarvestDistance(0.0)) {
                        if (this.holdingSeeds()) {
                            ItemStack seedStack = this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
                            seedStack.m_41764_(1);
                            this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                            Item item = seedStack.m_41720_();
                            if (item instanceof ItemNameBlockItem) {
                                ItemNameBlockItem item2 = (ItemNameBlockItem)item;
                                this.rat.m_9236_().m_46597_(this.getTargetBlock().m_7494_(), item2.m_40614_().m_49966_());
                            }
                        }
                        this.m_8041_();
                    }
                } else {
                    this.m_8041_();
                }
            } else if (this.holdingBonemeal()) {
                BlockState block = this.rat.m_9236_().m_8055_(this.getTargetBlock());
                this.rat.m_21573_().m_26519_((double)this.getTargetBlock().m_123341_() + 0.5, (double)this.getTargetBlock().m_123342_(), (double)this.getTargetBlock().m_123343_() + 0.5, 1.25);
                if (this.canPlantBeBonemealed(this.getTargetBlock(), block)) {
                    double distance = this.rat.getRatDistanceCenterSq(this.getTargetBlock().m_123341_(), this.getTargetBlock().m_123342_(), this.getTargetBlock().m_123343_());
                    if (distance < 4.5) {
                        if (this.holdingBonemeal()) {
                            BonemealableBlock bonemealable;
                            this.rat.m_21120_(InteractionHand.MAIN_HAND).m_41774_(1);
                            Block block2 = block.m_60734_();
                            if (block2 instanceof BonemealableBlock && (bonemealable = (BonemealableBlock)block2).m_7370_((LevelReader)this.rat.m_9236_(), this.getTargetBlock(), block, this.rat.m_9236_().m_5776_()) && !this.rat.m_9236_().m_5776_()) {
                                this.rat.m_9236_().m_46796_(2005, this.getTargetBlock(), 0);
                                this.rat.m_9236_().m_247517_(null, this.getTargetBlock(), SoundEvents.f_144074_, SoundSource.BLOCKS);
                                bonemealable.m_214148_((ServerLevel)this.rat.m_9236_(), this.rat.m_9236_().m_213780_(), this.getTargetBlock(), block);
                            }
                        }
                        this.m_8041_();
                    }
                } else {
                    this.m_8041_();
                }
            }
        }
    }

    private void resetTarget() {
        int RADIUS = this.rat.getRadius();
        if (this.holdingBonemeal()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
                if (!this.canPlantBeBonemealed(pos, this.rat.m_9236_().m_8055_(pos)) || RatUtils.isBlockProtected(this.rat.m_9236_(), pos, this.rat)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.getTargetSorter());
                this.setTargetBlock((BlockPos)allBlocks.get(0));
            }
        } else if (this.holdingSeeds()) {
            ArrayList<BlockPos> allBlocks = new ArrayList<BlockPos>();
            for (BlockPos pos : BlockPos.m_121990_((BlockPos)this.rat.getSearchCenter().m_7918_(-RADIUS, -RADIUS, -RADIUS), (BlockPos)this.rat.getSearchCenter().m_7918_(RADIUS, RADIUS, RADIUS)).map(BlockPos::m_7949_).toList()) {
                if (!this.rat.m_9236_().m_8055_(pos).m_60734_().isFertile(this.rat.m_9236_().m_8055_(pos), (BlockGetter)this.rat.m_9236_(), pos) || !this.rat.m_9236_().m_46859_(pos.m_7494_()) || RatUtils.isBlockProtected(this.rat.m_9236_(), pos, this.rat)) continue;
                allBlocks.add(pos);
            }
            if (!allBlocks.isEmpty()) {
                allBlocks.sort(this.getTargetSorter());
                this.setTargetBlock((BlockPos)allBlocks.get(0));
            }
        }
    }

    private boolean canPlantBeBonemealed(BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock bonemealable = (BonemealableBlock)block;
            if (state.m_204336_(BlockTags.f_13074_) && bonemealable.m_7370_((LevelReader)this.rat.m_9236_(), pos, state, this.rat.m_9236_().m_5776_())) {
                return bonemealable.m_214167_(this.rat.m_9236_(), this.rat.m_9236_().m_213780_(), pos, state);
            }
        }
        return false;
    }
}

