/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.rats.data.tags.RatsEntityTags;
import com.github.alexthe666.rats.registry.RatsItemRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.RatSummoner;
import com.github.alexthe666.rats.server.entity.ai.goal.BlackDeathSummonBeastGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.BlackDeathSummonCloudGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.BlackDeathSummonRatGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.BlackDeathSummoningGoal;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class BlackDeath
extends Monster
implements RatSummoner {
    private static final Predicate<LivingEntity> NOT_PLAGUE = entity -> entity.m_6084_() && !entity.m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION);
    private static final EntityDataAccessor<Boolean> IS_SUMMONING = SynchedEntityData.m_135353_(BlackDeath.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MELEE_ATTACKING = SynchedEntityData.m_135353_(BlackDeath.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> RAT_COUNT = SynchedEntityData.m_135353_(BlackDeath.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> CLOUD_COUNT = SynchedEntityData.m_135353_(BlackDeath.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEAST_COUNT = SynchedEntityData.m_135353_(BlackDeath.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
    private int summonTicks = 0;

    public BlackDeath(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21364_ = 50;
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new BlackDeathSummoningGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new BlackDeathSummonRatGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new BlackDeathSummonCloudGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new BlackDeathSummonBeastGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true){

            public boolean m_8036_() {
                return !BlackDeath.this.isSummoning() && super.m_8036_();
            }

            public boolean m_8045_() {
                return !BlackDeath.this.isSummoning() && super.m_8045_();
            }

            public void m_8056_() {
                super.m_8056_();
                BlackDeath.this.m_20088_().m_135381_(MELEE_ATTACKING, (Object)true);
            }

            public void m_8041_() {
                super.m_8041_();
                BlackDeath.this.m_20088_().m_135381_(MELEE_ATTACKING, (Object)false);
            }
        });
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean m_8036_() {
                return this.f_26135_.m_21188_() != null && !this.f_26135_.m_21188_().m_6095_().m_204039_(RatsEntityTags.PLAGUE_LEGION) && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> NOT_PLAGUE.and(EntitySelector.f_20406_).and(living -> living.m_6336_() != MobType.f_21641_).test((LivingEntity)entity)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(IS_SUMMONING, (Object)false);
        this.m_20088_().m_135372_(MELEE_ATTACKING, (Object)false);
        this.m_20088_().m_135372_(RAT_COUNT, (Object)0);
        this.m_20088_().m_135372_(CLOUD_COUNT, (Object)0);
        this.m_20088_().m_135372_(BEAST_COUNT, (Object)0);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.BLACK_DEATH_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.BLACK_DEATH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.BLACK_DEATH_DIE.get();
    }

    public boolean m_6094_() {
        return false;
    }

    public int m_8100_() {
        return 40;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_6084_()) {
            double dist = 20.0;
            for (Rat rat : this.m_9236_().m_45976_(Rat.class, new AABB(this.m_20185_() - dist, this.m_20186_() - dist, this.m_20189_() - dist, this.m_20185_() + dist, this.m_20186_() + dist, this.m_20189_() + dist))) {
                if (!rat.m_21830_((LivingEntity)this)) continue;
                rat.m_7105_(false);
                rat.m_21816_(null);
                rat.setFleePos(rat.m_20183_());
                rat.m_6710_(null);
                rat.m_6703_(null);
            }
        }
        super.m_142687_(reason);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.summonTicks > 0 && this.m_5448_() != null) {
            --this.summonTicks;
        }
    }

    public boolean m_6072_() {
        return false;
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean isSummoning() {
        return (Boolean)this.m_20088_().m_135370_(IS_SUMMONING);
    }

    public void setSummoning(boolean summoning) {
        this.m_20088_().m_135381_(IS_SUMMONING, (Object)summoning);
    }

    public boolean isMeleeAttacking() {
        return (Boolean)this.m_20088_().m_135370_(MELEE_ATTACKING);
    }

    @Override
    public boolean encirclesSummoner() {
        return true;
    }

    @Override
    public boolean reabsorbRats() {
        return false;
    }

    @Override
    public float reabsorbedRatHealAmount() {
        return 0.0f;
    }

    @Override
    public int getRatsSummoned() {
        return (Integer)this.m_20088_().m_135370_(RAT_COUNT);
    }

    @Override
    public void setRatsSummoned(int count) {
        this.m_20088_().m_135381_(RAT_COUNT, (Object)count);
    }

    @Override
    public float getRadius() {
        return 5.0f - (float)Math.sin((double)this.f_19797_ * 0.4) * 0.5f;
    }

    public int getCloudsSummoned() {
        return (Integer)this.m_20088_().m_135370_(CLOUD_COUNT);
    }

    public void setCloudsSummoned(int count) {
        this.m_20088_().m_135381_(CLOUD_COUNT, (Object)count);
    }

    public int getBeastsSummoned() {
        return (Integer)this.m_20088_().m_135370_(BEAST_COUNT);
    }

    public void setBeastsSummoned(int count) {
        this.m_20088_().m_135381_(BEAST_COUNT, (Object)count);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SummoningTicks", this.summonTicks);
        compound.m_128405_("RatsSummoned", this.getRatsSummoned());
        compound.m_128405_("CloudsSummoned", this.getCloudsSummoned());
        compound.m_128405_("BeastsSummoned", this.getBeastsSummoned());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
        this.summonTicks = compound.m_128451_("SummoningTicks");
        this.setRatsSummoned(compound.m_128451_("RatsSummoned"));
        this.setCloudsSummoned(compound.m_128451_("CloudsSummoned"));
        this.setBeastsSummoned(compound.m_128451_("BeastsSummoned"));
    }

    public int getSummonTicks() {
        return this.summonTicks;
    }

    public void setSummonTicks(int ticks) {
        this.summonTicks = ticks;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_9236_().m_5776_() && this.isSummoning()) {
            double d0 = 0.0;
            double d1 = 0.0;
            double d2 = 0.0;
            float f = this.m_146908_() * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.BLACK_DEATH.get(), this.m_20185_() + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + (double)f2 * 0.6, d0, d1, d2);
            this.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.BLACK_DEATH.get(), this.m_20185_() - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - (double)f2 * 0.6, d0, d1, d2);
        }
    }

    protected void m_213945_(RandomSource random, DifficultyInstance instance) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)RatsItemRegistry.PLAGUE_SCYTHE.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor accessor, DifficultyInstance difficulty, MobSpawnType type, @Nullable SpawnGroupData data, @Nullable CompoundTag tag) {
        SpawnGroupData finalData = super.m_6518_(accessor, difficulty, type, data, tag);
        this.m_213945_(accessor.m_213780_(), difficulty);
        this.m_213946_(accessor.m_213780_(), difficulty);
        return finalData;
    }
}

