/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.monster.boss;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.GolemBeam;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class RatlanteanAutomaton
extends Monster
implements IAnimatedEntity,
RangedAttackMob {
    public static final Animation ANIMATION_MELEE = Animation.create((int)15);
    public static final Animation ANIMATION_RANGED = Animation.create((int)15);
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS);
    private int blockBreakCounter;
    private int animationTick;
    private boolean useRangedAttack = false;
    private Animation currentAnimation;

    public RatlanteanAutomaton(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.m_274367_(2.0f);
        this.m_21573_().m_7008_(true);
        this.f_21364_ = 50;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    public boolean canDestroyBlock(BlockState state, BlockPos pos) {
        return !state.m_204336_(BlockTags.f_13070_) && state.m_60800_((BlockGetter)this.m_9236_(), pos) >= 0.0f;
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22280_, 0.8).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AIFollowPrey(this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.blockBreakCounter > 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 && ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                int i1 = Mth.m_14107_((double)this.m_20186_());
                int l1 = Mth.m_14107_((double)this.m_20185_());
                int i2 = Mth.m_14107_((double)this.m_20189_());
                boolean flag = false;
                for (int k2 = -2; k2 <= 2; ++k2) {
                    for (int l2 = -2; l2 <= 2; ++l2) {
                        for (int j = 1; j <= 3; ++j) {
                            int i3 = l1 + k2;
                            int k = i1 + j;
                            int l = i2 + l2;
                            BlockPos blockpos = new BlockPos(i3, k, l);
                            BlockState state = this.m_9236_().m_8055_(blockpos);
                            Block block = state.m_60734_();
                            if (block instanceof LiquidBlock || !this.canDestroyBlock(state, blockpos) || state.m_60795_() || !block.canEntityDestroy(state, (BlockGetter)this.m_9236_(), blockpos, (Entity)this) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)state)) continue;
                            flag = this.m_9236_().m_46961_(blockpos, true) || flag;
                        }
                    }
                }
                if (flag) {
                    this.m_9236_().m_5898_(null, 1022, this.m_20183_(), 0);
                }
            }
        }
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.useRangedAttack ? ANIMATION_MELEE : ANIMATION_RANGED);
        }
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (!(source.m_7639_() instanceof RatlanteanAutomaton)) {
            if (this.blockBreakCounter <= 0) {
                this.blockBreakCounter = 20;
            }
            return super.m_6469_(source, amount);
        }
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        this.useRangedAttack = true;
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_RANGED);
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_AUTOMATON_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_AUTOMATON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.RATLANTEAN_AUTOMATON_DIE.get();
    }

    public void m_8107_() {
        double extraY;
        double extraZ;
        double extraX;
        float angle;
        float radius;
        super.m_8107_();
        if (!this.m_20096_() && this.m_20184_().m_7098_() < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.75, 1.0));
        }
        if (this.m_5448_() != null && !this.m_5448_().m_6084_()) {
            this.m_6710_(null);
        }
        if (this.m_5448_() != null) {
            boolean bl = this.useRangedAttack = this.m_20270_((Entity)this.m_5448_()) > (float)RatConfig.automatonRangedDistance;
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_RANGED && this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
            this.setAnimation(ANIMATION_RANGED);
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && this.m_5448_() != null && this.m_20270_((Entity)this.m_5448_()) < (float)RatConfig.automatonMeleeDistance && this.m_142582_((Entity)this.m_5448_())) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_MELEE);
                this.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f + this.m_217043_().m_188501_() * 0.5f);
            }
            this.m_21391_((Entity)this.m_5448_(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_MELEE && this.getAnimationTick() == 10) {
                this.m_5448_().m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_));
                this.m_5448_().m_147240_(1.5, this.m_20185_() - this.m_5448_().m_20185_(), this.m_20189_() - this.m_5448_().m_20189_());
                boolean bl = this.useRangedAttack = this.m_217043_().m_188503_(RatConfig.automatonShootChance) == 0;
            }
        }
        if (this.m_9236_().m_5776_() && this.m_217043_().m_188500_() < 0.5) {
            radius = -0.5f;
            angle = (float)Math.PI / 180 * this.f_20883_;
            extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
            extraY = 0.75 + this.m_20186_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, extraX + (double)(this.m_217043_().m_188501_() * 0.5f) - 0.25, extraY, extraZ + (double)(this.m_217043_().m_188501_() * 0.5f) - 0.25, 0.0, (double)-0.15f, 0.0);
        }
        if (this.useRangedAttack && this.getAnimation() == ANIMATION_RANGED && this.getAnimationTick() == 6) {
            radius = -3.8f;
            angle = (float)Math.PI / 180 * this.f_20883_ - 160.0f;
            extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
            extraY = (double)2.4f + this.m_20186_();
            double targetRelativeX = (this.m_5448_() == null ? this.m_20252_((float)1.0f).f_82479_ : this.m_5448_().m_20185_()) - extraX;
            double targetRelativeY = (this.m_5448_() == null ? this.m_20252_((float)1.0f).f_82480_ : this.m_5448_().m_20186_()) - extraY;
            double targetRelativeZ = (this.m_5448_() == null ? this.m_20252_((float)1.0f).f_82481_ : this.m_5448_().m_20189_()) - extraZ;
            GolemBeam beam = new GolemBeam((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON_BEAM.get()), this.m_9236_(), (LivingEntity)this);
            beam.m_6034_(extraX, extraY, extraZ);
            beam.m_6686_(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.1f);
            this.m_5496_((SoundEvent)RatsSoundRegistry.LASER.get(), 1.0f, 0.75f + this.m_217043_().m_188501_() * 0.5f);
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)beam);
            }
            this.useRangedAttack = this.m_217043_().m_188499_();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MELEE, ANIMATION_RANGED};
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    class AIFollowPrey
    extends Goal {
        private final RatlanteanAutomaton parentEntity;
        private double followDist;

        public AIFollowPrey(RatlanteanAutomaton ghast) {
            this.parentEntity = ghast;
        }

        public boolean m_8036_() {
            this.followDist = RatlanteanAutomaton.this.m_20191_().m_82309_();
            LivingEntity LivingEntity2 = this.parentEntity.m_5448_();
            double maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            return LivingEntity2 != null && ((double)LivingEntity2.m_20270_((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.m_142582_((Entity)LivingEntity2));
        }

        public void m_8037_() {
            double maxFollow;
            LivingEntity LivingEntity2 = this.parentEntity.m_5448_();
            double d = maxFollow = this.parentEntity.useRangedAttack ? 5.0 * this.followDist : this.followDist;
            if ((double)LivingEntity2.m_20270_((Entity)this.parentEntity) >= maxFollow || !this.parentEntity.m_142582_((Entity)LivingEntity2)) {
                RatlanteanAutomaton.this.m_21566_().m_6849_(LivingEntity2.m_20185_(), LivingEntity2.m_20186_() + 1.0, LivingEntity2.m_20189_(), 1.0);
            }
        }
    }
}

