/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.GolemBeam;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

public class RatAutomatonMount
extends RatMountBase
implements IAnimatedEntity {
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_MELEE = Animation.create((int)15);
    public static final Animation ANIMATION_RANGED = Animation.create((int)15);
    private boolean useRangedAttack = false;

    public RatAutomatonMount(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(2.0f);
        this.riderY = 2.725f;
        this.f_21342_ = new FlyingMoveControl((Mob)this, 10, false);
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_MELEE, ANIMATION_RANGED};
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 0.75);
    }

    public boolean m_7327_(Entity entity) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.useRangedAttack ? ANIMATION_MELEE : ANIMATION_RANGED);
        }
        return true;
    }

    @Override
    public void m_8107_() {
        double extraY;
        double extraZ;
        double extraX;
        float angle;
        float radius;
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null) {
            boolean bl = this.useRangedAttack = this.m_20270_((Entity)target) > 10.0f;
        }
        if (this.useRangedAttack && this.getAnimation() != ANIMATION_RANGED && target != null && this.m_142582_((Entity)target) && target.m_6084_()) {
            this.setAnimation(ANIMATION_RANGED);
            this.m_21391_((Entity)target, 360.0f, 80.0f);
        }
        if (!this.useRangedAttack && target != null && this.m_20270_((Entity)target) < 7.0f && this.m_142582_((Entity)target) && target.m_6084_()) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_MELEE);
                this.m_5496_(SoundEvents.f_12317_, 1.0f, 0.5f + this.m_217043_().m_188501_() * 0.5f);
            }
            this.m_21391_((Entity)target, 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_MELEE && this.getAnimationTick() == 10) {
                target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 6.0f);
                target.m_147240_(1.5, this.m_20185_() - target.m_20185_(), this.m_20189_() - target.m_20189_());
                this.useRangedAttack = this.m_217043_().m_188499_();
            }
        }
        if (this.m_9236_().m_5776_() && this.m_217043_().m_188500_() < 0.5) {
            radius = -0.5f;
            angle = (float)Math.PI / 180 * this.f_20883_;
            extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
            extraY = 1.25 + this.m_20186_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, extraX + (double)(this.m_217043_().m_188501_() * 0.5f) - 0.25, extraY, extraZ + (double)(this.m_217043_().m_188501_() * 0.5f) - 0.25, 0.0, (double)-0.1f, 0.0);
        }
        if (this.useRangedAttack && this.getAnimation() == ANIMATION_RANGED && this.getAnimationTick() == 6) {
            radius = -3.4f;
            angle = (float)Math.PI / 180 * this.f_20883_ - 160.0f;
            extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + this.m_20185_();
            extraZ = (double)(radius * Mth.m_14089_((float)angle)) + this.m_20189_();
            extraY = (double)2.4f + this.m_20186_();
            double targetRelativeX = (target == null ? this.m_20252_((float)1.0f).f_82479_ : target.m_20185_()) - extraX;
            double targetRelativeY = (target == null ? this.m_20252_((float)1.0f).f_82480_ : target.m_20186_()) - extraY;
            double targetRelativeZ = (target == null ? this.m_20252_((float)1.0f).f_82481_ : target.m_20189_()) - extraZ;
            GolemBeam beam = new GolemBeam((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.RATLANTEAN_AUTOMATON_BEAM.get()), this.m_9236_(), (LivingEntity)this);
            beam.m_6034_(extraX, extraY, extraZ);
            beam.m_6686_(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.1f);
            this.m_5496_((SoundEvent)RatsSoundRegistry.LASER.get(), 1.0f, 0.75f + this.m_217043_().m_188501_() * 0.5f);
            if (!this.m_9236_().m_5776_()) {
                this.m_9236_().m_7967_((Entity)beam);
            }
            this.useRangedAttack = this.m_217043_().m_188499_();
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    @Override
    public Item getUpgradeItem() {
        return (Item)RatlantisItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT.get();
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 0.5f, 0.0f, 0.0f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, -0.3f, 0.0f, 0.0f, 20.0f);
    }
}

