/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.mount;

import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatlantisItemRegistry;
import com.github.alexthe666.rats.registry.RatsSoundRegistry;
import com.github.alexthe666.rats.server.entity.Plane;
import com.github.alexthe666.rats.server.entity.ai.navigation.control.PlaneMoveControl;
import com.github.alexthe666.rats.server.entity.mount.RatMountBase;
import com.github.alexthe666.rats.server.entity.projectile.ArrowlikeProjectile;
import com.github.alexthe666.rats.server.entity.projectile.RattlingGunBullet;
import com.github.alexthe666.rats.server.entity.rat.AbstractRat;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.misc.PlaneRotationUtil;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RatBiplaneMount
extends RatMountBase
implements Plane {
    public float prevPlanePitch;
    private static final EntityDataAccessor<Boolean> FIRING = SynchedEntityData.m_135353_(RatBiplaneMount.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> PLANE_PITCH = SynchedEntityData.m_135353_(RatBiplaneMount.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public PlaneRotationUtil rollBuffer;
    public PlaneRotationUtil pitchBuffer;
    @Nullable
    private Vec3 flightTarget;
    private int soundLoopCounter = 0;

    public RatBiplaneMount(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
        this.riderY = 1.35f;
        this.riderXZ = -0.35f;
        this.f_21342_ = new PlaneMoveControl<RatBiplaneMount>(this);
        if (this.m_9236_().m_5776_()) {
            this.rollBuffer = new PlaneRotationUtil();
            this.pitchBuffer = new PlaneRotationUtil();
        }
    }

    @Override
    protected void m_8022_() {
        this.f_21345_.m_25360_(Goal.Flag.MOVE, false);
        this.f_21345_.m_25360_(Goal.Flag.JUMP, true);
        this.f_21345_.m_25360_(Goal.Flag.LOOK, true);
        this.f_21345_.m_25360_(Goal.Flag.TARGET, true);
    }

    @Override
    public void m_19956_(Entity passenger, Entity.MoveFunction callback) {
        super.m_19956_(passenger, callback);
        float radius = 0.35f;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = 1.35f;
        callback.m_20372_(passenger, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
        if (passenger instanceof LivingEntity) {
            ((LivingEntity)passenger).f_20883_ = this.f_20883_;
            passenger.m_146922_(this.f_20883_);
            ((LivingEntity)passenger).f_20885_ = this.f_20883_;
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(FIRING, (Object)false);
        this.m_20088_().m_135372_(PLANE_PITCH, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6785_(double dist) {
        return false;
    }

    public float getPlanePitch() {
        return ((Float)this.m_20088_().m_135370_(PLANE_PITCH)).floatValue();
    }

    public void setPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() + pitch));
    }

    public void decrementPlanePitch(float pitch) {
        this.m_20088_().m_135381_(PLANE_PITCH, (Object)Float.valueOf(this.getPlanePitch() - pitch));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 300.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_20096_()) {
            if (this.soundLoopCounter == 0) {
                this.m_5496_((SoundEvent)RatsSoundRegistry.BIPLANE_LOOP.get(), 10.0f, 1.0f);
            }
            ++this.soundLoopCounter;
            if (this.soundLoopCounter > 90) {
                this.soundLoopCounter = 0;
            }
        } else {
            this.soundLoopCounter = 0;
        }
        this.prevPlanePitch = this.getPlanePitch();
        if (!this.m_20160_() && !this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
        if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        TamedRat rat = this.getRat();
        if (this.m_5448_() != null && this.m_142582_((Entity)this.m_5448_())) {
            LivingEntity target = this.m_5448_();
            if (this.f_19797_ % 2 == 0) {
                for (int i = 0; i < 2; ++i) {
                    boolean left = i == 0;
                    float radius = 1.15f;
                    float angle = (float)Math.PI / 180 * this.f_20883_ + (float)(left ? 75 : -75);
                    double extraX = this.m_20185_() + (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle))));
                    double extraZ = this.m_20189_() + (double)(radius * Mth.m_14089_((float)angle));
                    double extraY = this.m_20186_() + (double)1.35f;
                    double d0 = target.m_20186_() + (double)target.m_20192_() / 2.0;
                    double d1 = target.m_20185_() - extraX;
                    double d3 = target.m_20189_() - extraZ;
                    double d2 = d0 - extraY;
                    float velocity = 3.2f;
                    RattlingGunBullet cannonball = new RattlingGunBullet((EntityType<? extends ArrowlikeProjectile>)((EntityType)RatlantisEntityRegistry.RATTLING_GUN_BULLET.get()), this.m_9236_(), (LivingEntity)this);
                    cannonball.m_6034_(extraX, extraY, extraZ);
                    cannonball.setBaseDamage(0.5);
                    cannonball.m_6686_(d1, d2, d3, velocity, 1.4f);
                    this.m_5496_((SoundEvent)RatsSoundRegistry.BIPLANE_SHOOT.get(), 3.0f, 2.3f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                    if (this.m_9236_().m_5776_()) continue;
                    this.m_9236_().m_7967_((Entity)cannonball);
                }
            }
            this.setFiring(true);
        }
        if (this.getFlightTarget() == null || this.m_20275_(this.getFlightTarget().m_7096_(), this.getFlightTarget().m_7098_(), this.getFlightTarget().m_7094_()) < 20.0 || rat != null && !rat.canMove()) {
            this.setFlightTarget(null);
        }
        if (this.m_9236_().m_5776_() && !this.m_20096_()) {
            this.rollBuffer.calculateChainFlapBuffer(40.0f, 20, 0.5f, 0.5f, (LivingEntity)this);
            this.pitchBuffer.calculateChainWaveBuffer(40.0f, 10, 0.5f, 0.5f, (LivingEntity)this);
        }
        if (!this.m_20096_()) {
            double ydist = this.f_19855_ - this.m_20186_();
            float planeDist = (float)((Math.abs(this.m_20184_().m_7096_()) + Math.abs(this.m_20184_().m_7094_())) * 6.0);
            this.incrementPlanePitch((float)ydist * 10.0f);
            this.setPlanePitch(Mth.m_14036_((float)this.getPlanePitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            if (this.getPlanePitch() > plateau) {
                this.decrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() < -plateau) {
                this.incrementPlanePitch(planeDist * Math.abs(this.getPlanePitch()) / 90.0f);
            }
            if (this.getPlanePitch() > 2.0f) {
                this.decrementPlanePitch(1.0f);
            } else if (this.getPlanePitch() < -2.0f) {
                this.incrementPlanePitch(1.0f);
            }
        } else {
            this.setPlanePitch(0.0f);
        }
    }

    public boolean isFiring() {
        return (Boolean)this.m_20088_().m_135370_(FIRING);
    }

    public void setFiring(boolean firing) {
        this.m_20088_().m_135381_(FIRING, (Object)firing);
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)RatsSoundRegistry.BIPLANE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)RatsSoundRegistry.BIPLANE_DEATH.get();
    }

    @Override
    public Item getUpgradeItem() {
        return (Item)RatlantisItemRegistry.RAT_UPGRADE_BIPLANE_MOUNT.get();
    }

    @Override
    public boolean shouldTeleportWhenFarAway() {
        return false;
    }

    @Override
    @Nullable
    public Vec3 getFlightTarget() {
        return this.flightTarget;
    }

    @Override
    public void setFlightTarget(@Nullable Vec3 target) {
        this.flightTarget = target;
    }

    @Override
    public void adjustRatTailRotation(AbstractRat rat, AdvancedModelBox upperTail, AdvancedModelBox lowerTail) {
        this.progressRotation(upperTail, rat.sitProgress, 1.3f, 0.0f, 0.0f, 20.0f);
        this.progressRotation(lowerTail, rat.sitProgress, -0.2f, 0.0f, 0.0f, 20.0f);
    }
}

