/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity.projectile;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ThrownBlock
extends Entity {
    public LivingEntity shootingEntity;
    private static final EntityDataAccessor<Optional<BlockState>> CARRIED_BLOCK = SynchedEntityData.m_135353_(ThrownBlock.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    public boolean dropBlock = true;
    public CompoundTag tileEntityData;
    private int ticksAlive;
    private int ticksInAir;

    public ThrownBlock(EntityType<? extends Entity> type, Level level) {
        super(type, level);
    }

    public ThrownBlock(EntityType<? extends Entity> type, Level level, BlockState blockState, LivingEntity entityNeoRatlantean) {
        super(type, level);
        this.setHeldBlockState(blockState);
        this.shootingEntity = entityNeoRatlantean;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(CARRIED_BLOCK, Optional.empty());
    }

    public void setHeldBlockState(@Nullable BlockState state) {
        this.m_20088_().m_135381_(CARRIED_BLOCK, Optional.ofNullable(state));
    }

    @Nullable
    public BlockState getHeldBlockState() {
        return ((Optional)this.m_20088_().m_135370_(CARRIED_BLOCK)).orElse(null);
    }

    public boolean m_6783_(double distance) {
        double d0 = this.m_20191_().m_82309_() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public boolean m_7337_(Entity entity) {
        if (!entity.m_5833_() && entity.m_6084_() && entity.m_5829_()) {
            LivingEntity shooter = this.shootingEntity;
            return shooter == null || !entity.m_20365_(entity);
        }
        return false;
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_() || (this.shootingEntity == null || this.shootingEntity.m_6084_()) && this.m_9236_().m_46749_(this.m_20183_())) {
            Mob mob;
            LivingEntity livingEntity;
            super.m_8119_();
            ++this.ticksInAir;
            if (this.ticksInAir > 25) {
                this.f_19794_ = true;
                HitResult raytraceresult = ProjectileUtil.m_278158_((Entity)this, this::m_7337_);
                this.onHit(raytraceresult);
            } else {
                this.f_19794_ = false;
            }
            this.m_6034_(this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_, this.m_20189_() + this.m_20184_().f_82481_);
            ProjectileUtil.m_37284_((Entity)this, (float)0.2f);
            if (this.m_20069_()) {
                for (int i = 0; i < 4; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123795_, this.m_20185_() - this.m_20184_().f_82479_ * 0.25, this.m_20186_() - this.m_20184_().f_82480_ * 0.25, this.m_20189_() - this.m_20184_().f_82481_ * 0.25, this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_);
                }
            }
            if (this.shootingEntity != null && (livingEntity = this.shootingEntity) instanceof Mob && (mob = (Mob)livingEntity).m_5448_() != null) {
                LivingEntity target = mob.m_5448_();
                double d0 = target.m_20185_() - this.m_20185_();
                double d1 = target.m_20186_() - this.m_20186_();
                double d2 = target.m_20189_() - this.m_20189_();
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                d3 = Mth.m_14116_((float)((float)d3));
                Vec3 vec3d = this.m_20184_();
                vec3d = vec3d.m_82520_(d0 / d3 * 0.2, d1 / d3 * 0.2, d2 / d3 * 0.2);
                this.m_20256_(vec3d);
            }
        } else {
            this.m_146870_();
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    protected void onHit(HitResult result) {
        if (this.getHeldBlockState() != null) {
            Block block = this.getHeldBlockState().m_60734_();
            BlockPos pos = null;
            if (result instanceof BlockHitResult) {
                BlockHitResult blockResult = (BlockHitResult)result;
                pos = blockResult.m_82425_();
            }
            if (result instanceof EntityHitResult) {
                EntityHitResult entityResult = (EntityHitResult)result;
                pos = entityResult.m_82443_().m_20183_();
            }
            if (pos != null) {
                BlockEntity tileentity;
                for (Entity hitMobs : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(1.0, 1.0, 1.0))) {
                    hitMobs.m_6469_(this.m_269291_().m_269318_(), 8.0f);
                }
                BlockPos blockpos1 = pos.m_7494_();
                if (this.dropBlock) {
                    this.m_9236_().m_46597_(blockpos1, this.getHeldBlockState());
                }
                if (this.tileEntityData != null && this.getHeldBlockState().m_155947_() && (tileentity = this.m_9236_().m_7702_(blockpos1)) != null) {
                    CompoundTag CompoundTag2 = tileentity.m_187482_();
                    for (String s : this.tileEntityData.m_128431_()) {
                        Tag nbtbase = this.tileEntityData.m_128423_(s);
                        if ("x".equals(s) || "y".equals(s) || "z".equals(s)) continue;
                        CompoundTag2.m_128365_(s, nbtbase.m_6426_());
                    }
                    tileentity.m_6596_();
                }
                this.m_146870_();
                if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
                    if (!this.m_9236_().m_5776_() && this.dropBlock) {
                        this.m_5552_(new ItemStack((ItemLike)block, 1), 0.0f);
                    }
                    this.m_146870_();
                }
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("direction", (Tag)this.m_20063_(new double[]{this.m_20184_().f_82479_, this.m_20184_().f_82480_, this.m_20184_().f_82481_}));
        compound.m_128405_("life", this.ticksAlive);
        BlockState blockstate = this.getHeldBlockState();
        if (blockstate != null) {
            compound.m_128365_("carriedBlockState", (Tag)NbtUtils.m_129202_((BlockState)blockstate));
        }
        if (this.tileEntityData != null) {
            compound.m_128365_("TileEntityData", (Tag)this.tileEntityData);
        }
    }

    public void m_7378_(CompoundTag compound) {
        this.ticksAlive = compound.m_128451_("life");
        if (compound.m_128425_("direction", 9) && compound.m_128437_("direction", 6).size() == 3) {
            ListTag nbttaglist1 = compound.m_128437_("direction", 6);
            this.m_20334_(nbttaglist1.m_128772_(0), nbttaglist1.m_128772_(1), nbttaglist1.m_128772_(2));
        } else {
            this.m_146870_();
        }
        BlockState blockstate = null;
        if (compound.m_128425_("carriedBlockState", 10) && (blockstate = NbtUtils.m_247651_((HolderGetter)this.m_9236_().m_9598_().m_255025_(Registries.f_256747_), (CompoundTag)compound.m_128469_("carriedBlockState"))).m_60795_()) {
            blockstate = null;
        }
        if (blockstate != null) {
            this.setHeldBlockState(blockstate);
        }
        if (compound.m_128425_("TileEntityData", 10)) {
            this.tileEntityData = compound.m_128469_("TileEntityData");
        }
    }

    public boolean m_5829_() {
        return true;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        if (source.m_7639_() != null) {
            Vec3 vec3d = source.m_7639_().m_20154_();
            this.m_20256_(vec3d);
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity living;
                this.shootingEntity = living = (LivingEntity)entity;
            }
            return true;
        }
        return false;
    }
}

