/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.inventory;

import com.github.alexthe666.rats.registry.RatsMenuRegistry;
import com.github.alexthe666.rats.registry.RatsUpgradeConflictRegistry;
import com.github.alexthe666.rats.server.inventory.container.RatContainer;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.mojang.datafixers.util.Pair;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;

public class RatMenu
extends AbstractContainerMenu {
    private final Container ratInventory;
    private static final ResourceLocation EMPTY_HELMET_SLOT = new ResourceLocation("rats", "item/empty_rat_helmet_slot");
    private static final ResourceLocation EMPTY_BANNER_SLOT = new ResourceLocation("rats", "item/empty_rat_banner_slot");
    private static final ResourceLocation EMPTY_ITEM_SLOT = new ResourceLocation("rats", "item/empty_rat_item_slot");
    private static final ResourceLocation EMPTY_UPGRADE_SLOT = new ResourceLocation("rats", "item/empty_rat_upgrade_slot");

    public RatMenu(int id, Container ratInventory, final Inventory playerInventory) {
        super((MenuType)RatsMenuRegistry.RAT_CONTAINER.get(), id);
        this.ratInventory = ratInventory;
        ratInventory.m_5856_(playerInventory.f_35978_);
        this.m_38897_(new Slot(ratInventory, 0, 70, 54){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_ITEM_SLOT);
            }
        });
        this.m_38897_(new Slot(ratInventory, 1, 70, 18){

            public boolean m_5857_(ItemStack stack) {
                return super.m_5857_(stack) && !stack.m_41619_() && stack.m_41720_().canEquip(stack, EquipmentSlot.HEAD, (Entity)playerInventory.f_35978_);
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_HELMET_SLOT);
            }
        });
        this.m_38897_(new Slot(ratInventory, 2, 70, 36){

            public boolean m_5857_(ItemStack stack) {
                return super.m_5857_(stack) && !stack.m_41619_() && stack.m_41720_() instanceof BannerItem;
            }

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_BANNER_SLOT);
            }
        });
        int i = 0;
        while (i <= 2) {
            final int finalI = i++;
            this.m_38897_(new Slot(ratInventory, 3 + finalI, -2, 18 + finalI * 18){

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    return super.m_5857_(stack) && !stack.m_41619_() && stack.m_41720_() instanceof BaseRatUpgradeItem && RatMenu.canCoexistUpgrade(this.f_40218_, stack, finalI);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_UPGRADE_SLOT);
                }
            });
        }
        for (int j = 0; j < 3; ++j) {
            for (int k1 = 0; k1 < 9; ++k1) {
                this.m_38897_(new Slot((Container)playerInventory, k1 + j * 9 + 9, 8 + k1 * 18, 102 + j * 18 - 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public RatMenu(int i, Inventory inventory) {
        this(i, (Container)new SimpleContainer(6), inventory);
    }

    public static boolean canCoexistUpgrade(Container inventory, ItemStack upgrade, int ourSlot) {
        return switch (ourSlot) {
            case 0 -> {
                if (!RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(4)) && !RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(5))) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (!RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(3)) && !RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(5))) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (!RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(3)) && !RatsUpgradeConflictRegistry.doesConflict(upgrade, inventory.m_8020_(4))) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    public boolean m_6875_(Player player) {
        return this.ratInventory.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.ratInventory.m_6643_() ? !this.m_38903_(itemstack1, this.ratInventory.m_6643_(), this.f_38839_.size(), true) : (this.m_38853_(1).m_5857_(itemstack1) && !this.m_38853_(1).m_6657_() ? !this.m_38903_(itemstack1, 1, 2, false) : (this.m_38853_(2).m_5857_(itemstack1) && !this.m_38853_(2).m_6657_() ? !this.m_38903_(itemstack1, 2, 3, false) : (this.m_38853_(3).m_5857_(itemstack1) && !this.m_38853_(3).m_6657_() ? !this.m_38903_(itemstack1, 3, 4, false) : (this.m_38853_(4).m_5857_(itemstack1) && !this.m_38853_(4).m_6657_() ? !this.m_38903_(itemstack1, 4, 5, false) : (this.m_38853_(5).m_5857_(itemstack1) && !this.m_38853_(5).m_6657_() ? !this.m_38903_(itemstack1, 5, 6, false) : (this.m_38853_(0).m_5857_(itemstack1) ? !this.m_38903_(itemstack1, 0, 1, false) : this.ratInventory.m_6643_() <= 6 || !this.m_38903_(itemstack1, 6, this.ratInventory.m_6643_(), false)))))))) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.ratInventory.m_5785_(player);
        Container container = this.ratInventory;
        if (container instanceof RatContainer) {
            RatContainer container2 = (RatContainer)container;
            container2.getRat().closeInventory();
        }
    }
}

