/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.server.entity.ai.goal.RatDepositGoal;
import com.github.alexthe666.rats.server.entity.ai.goal.RatPickupGoal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.ChangesAIUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class BucketRatUpgradeItem
extends BaseRatUpgradeItem
implements HoldsItemUpgrade,
ChangesAIUpgrade {
    private final int fluidAmount;

    public BucketRatUpgradeItem(Item.Properties properties, int rarity, int textLength, int fluidAmount) {
        super(properties, rarity, textLength);
        this.fluidAmount = fluidAmount;
    }

    public static ItemStack getBucketFromFluid(FluidStack ingredient) {
        if (ingredient.isEmpty()) {
            return new ItemStack((ItemLike)Items.f_42446_);
        }
        return FluidUtil.getFilledBucket((FluidStack)ingredient);
    }

    public int getMbTransferRate() {
        return this.fluidAmount;
    }

    @Override
    public void renderHeldItem(EntityRendererProvider.Context context, TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        stack.m_85836_();
        if (model.f_102610_) {
            stack.m_252880_(0.0f, 0.625f, 0.0f);
            stack.m_252781_(Axis.f_252529_.m_252977_(20.0f));
            stack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        this.translateToHand(model, true, stack);
        stack.m_252781_(Axis.f_252403_.m_252977_(190.0f));
        stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        stack.m_252781_(Axis.f_252495_.m_252977_(40.0f));
        stack.m_252880_(-0.155f, -0.25f, 0.0f);
        stack.m_85841_(1.25f, 1.25f, 1.25f);
        context.m_174025_().m_269128_(BucketRatUpgradeItem.getBucketFromFluid(rat.transportingFluid), ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
        stack.m_85849_();
    }

    @Override
    public List<Goal> addNewWorkGoals(TamedRat rat) {
        return List.of(new RatPickupGoal(rat, RatPickupGoal.PickupType.FLUID), new RatDepositGoal(rat, RatDepositGoal.DepositType.FLUID));
    }
}

