/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.server.inventory.JuryRiggedRatUpgradeMenu;
import com.github.alexthe666.rats.server.inventory.container.RatUpgradeContainer;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.CombinedUpgrade;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class JuryRiggedRatUpgradeItem
extends BaseRatUpgradeItem
implements CombinedUpgrade {
    public JuryRiggedRatUpgradeItem(Item.Properties properties) {
        super(properties, 1, 2);
    }

    @Override
    public int getUpgradeSlots() {
        return 2;
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        tooltip.add((Component)Component.m_237115_((String)"item.rats.rat_upgrade_combined.desc").m_130940_(ChatFormatting.GRAY));
        this.addTooltip(stack, tooltip);
    }

    @Override
    public boolean m_5812_(ItemStack stack) {
        return this.isUpgradeLocked(stack);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        final ItemStack stack = player.m_21120_(hand);
        if (!(player.m_6144_() || this.isUpgradeLocked(stack) || level.m_5776_())) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player1) {
                    return new JuryRiggedRatUpgradeMenu(id, (Container)new RatUpgradeContainer(stack), player1.m_150109_(), stack);
                }

                public Component m_5446_() {
                    return JuryRiggedRatUpgradeItem.this.m_7626_(stack);
                }
            });
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private boolean isUpgradeLocked(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_("Items", 9)) {
            NonNullList nonnulllist = NonNullList.m_122780_((int)this.getUpgradeSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
            return !((ItemStack)nonnulllist.get(0)).m_41619_() && !((ItemStack)nonnulllist.get(1)).m_41619_();
        }
        return false;
    }
}

