/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.items.upgrades;

import com.github.alexthe666.rats.client.model.entity.RatModel;
import com.github.alexthe666.rats.registry.RatlantisBlockRegistry;
import com.github.alexthe666.rats.registry.RatlantisEntityRegistry;
import com.github.alexthe666.rats.registry.RatsParticleRegistry;
import com.github.alexthe666.rats.server.entity.misc.LaserPortal;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.StatBoostingRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.HoldsItemUpgrade;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.TickRatUpgrade;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class PsychicRatUpgradeItem
extends StatBoostingRatUpgradeItem
implements TickRatUpgrade,
HoldsItemUpgrade {
    public PsychicRatUpgradeItem(Item.Properties properties) {
        super(properties, 2, 1, Map::of, true);
    }

    @Override
    public void renderHeldItem(EntityRendererProvider.Context context, TamedRat rat, RatModel<?> model, PoseStack stack, MultiBufferSource buffer, int light, float ageInTicks) {
        if (!rat.m_21033_(EquipmentSlot.HEAD)) {
            stack.m_85836_();
            this.translateToHead(model, stack);
            stack.m_252880_(0.0f, 0.1f, 0.035f);
            stack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            stack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            stack.m_85841_(0.9f, 0.9f, 0.9f);
            context.m_174025_().m_269128_(new ItemStack((ItemLike)RatlantisBlockRegistry.BRAIN_BLOCK.get()), ItemDisplayContext.GROUND, light, OverlayTexture.f_118083_, stack, buffer, null, rat.m_19879_());
            stack.m_85849_();
        }
    }

    @Override
    public boolean isFakeHandRender() {
        return true;
    }

    @Override
    public void tick(TamedRat rat) {
        if (rat.m_9236_().m_5776_() && rat.m_217043_().m_188503_(5) == 0) {
            float sitAddition = 0.125f * (rat.sitProgress / 20.0f);
            float radius = 0.45f - sitAddition;
            float angle = (float)Math.PI / 180 * rat.f_20883_;
            double extraX = (double)(radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)))) + rat.m_20185_();
            double extraZ = (double)(radius * Mth.m_14089_((float)angle)) + rat.m_20189_();
            double extraY = 0.12 + rat.m_20186_() + (double)sitAddition;
            float particleRand = 0.4f;
            rat.m_9236_().m_7106_((ParticleOptions)RatsParticleRegistry.LIGHTNING.get(), extraX + (double)(rat.m_217043_().m_188501_() * particleRand * 2.0f) - (double)particleRand, extraY, extraZ + (double)(rat.m_217043_().m_188501_() * particleRand * 2.0f) - (double)particleRand, 0.0, 0.0, 0.0);
        }
        if (rat.rangedAttackCooldown == 0 && rat.m_5448_() != null) {
            if (rat.m_217043_().m_188499_()) {
                // empty if block
            }
            rat.rangedAttackCooldown = 100;
            int bounds = 5;
            for (int i = 0; i < rat.m_217043_().m_188503_(2) + 1; ++i) {
                LaserPortal laserPortal = new LaserPortal((EntityType<? extends Entity>)((EntityType)RatlantisEntityRegistry.LASER_PORTAL.get()), rat.m_9236_(), rat.m_5448_().m_20185_() + (double)rat.m_217043_().m_188503_(bounds * 2) - (double)bounds, rat.m_20186_() + 2.0, rat.m_5448_().m_20189_() + (double)rat.m_217043_().m_188503_(bounds * 2) - (double)bounds, (LivingEntity)rat);
                rat.m_9236_().m_7967_((Entity)laserPortal);
            }
        }
    }
}

