/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class GenericAddItemLootModifier
extends LootModifier {
    public static final Codec<GenericAddItemLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.unboundedMap((Codec)ForgeRegistries.ITEMS.getCodec(), (Codec)Codec.INT).fieldOf("items").forGetter(m -> m.items), (App)Codec.BOOL.fieldOf("replacePool").orElse((Object)false).forGetter(m -> m.makeNewPool))).apply((Applicative)inst, GenericAddItemLootModifier::new));
    private final Map<Item, Integer> items;
    private final boolean makeNewPool;

    private GenericAddItemLootModifier(LootItemCondition[] conditions, Map<Item, Integer> items, boolean makeNewPool) {
        super(conditions);
        this.items = items;
        this.makeNewPool = makeNewPool;
    }

    public GenericAddItemLootModifier(LootItemCondition[] conditions, boolean makeNewPool, ItemStack ... stacks) {
        super(conditions);
        this.items = new HashMap<Item, Integer>();
        for (ItemStack stack : stacks) {
            this.items.put(stack.m_41720_(), stack.m_41613_());
        }
        this.makeNewPool = makeNewPool;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        if (this.makeNewPool) {
            generatedLoot.clear();
            if (this.items.size() > 1) {
                int chosenEntry = context.m_230907_().m_188503_(this.items.size());
                Item chosenItem = new ArrayList<Item>(this.items.keySet()).get(chosenEntry);
                generatedLoot.add((Object)new ItemStack((ItemLike)chosenItem, this.items.get(chosenItem).intValue()));
            } else {
                for (Map.Entry<Item, Integer> entry : this.items.entrySet()) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)entry.getKey(), entry.getValue().intValue()));
                }
            }
        } else {
            for (Map.Entry<Item, Integer> entry : this.items.entrySet()) {
                generatedLoot.add((Object)new ItemStack((ItemLike)entry.getKey(), entry.getValue().intValue()));
            }
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

