/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public record SyncPlaguePacket(int entityId, byte effectId, byte amplifier, int duration, byte flags) {
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;

    public SyncPlaguePacket(int id, MobEffectInstance effect) {
        this(id, (byte)(MobEffect.m_19459_((MobEffect)effect.m_19544_()) & 0xFF), (byte)(effect.m_19564_() & 0xFF), Math.min(effect.m_19557_(), Short.MAX_VALUE), SyncPlaguePacket.getFlags(effect));
    }

    private static byte getFlags(MobEffectInstance mobEffectInstance) {
        byte flags = 0;
        if (mobEffectInstance.m_19571_()) {
            flags = (byte)(flags | 1);
        }
        if (mobEffectInstance.m_19572_()) {
            flags = (byte)(flags | 2);
        }
        if (mobEffectInstance.m_19575_()) {
            flags = (byte)(flags | 4);
        }
        return flags;
    }

    public boolean isEffectVisible() {
        return (this.flags() & 2) == 2;
    }

    public boolean isEffectAmbient() {
        return (this.flags() & 1) == 1;
    }

    public boolean effectShowsIcon() {
        return (this.flags() & 4) == 4;
    }

    public static SyncPlaguePacket decode(FriendlyByteBuf buf) {
        return new SyncPlaguePacket(buf.m_130242_(), buf.readByte(), buf.readByte(), buf.m_130242_(), buf.readByte());
    }

    public static void encode(SyncPlaguePacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.entityId());
        buf.writeByte((int)packet.effectId());
        buf.writeByte((int)packet.amplifier());
        buf.m_130130_(packet.duration());
        buf.writeByte((int)packet.flags());
    }

    public static class Handler {
        public static void handle(final SyncPlaguePacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    if (Minecraft.m_91087_().f_91073_ == null) {
                        return;
                    }
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(packet.entityId());
                    if (entity instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity;
                        MobEffect mobeffect = MobEffect.m_19453_((int)(packet.effectId() & 0xFF));
                        if (mobeffect != null) {
                            if (packet.duration() == 0) {
                                living.m_21195_(mobeffect);
                            } else {
                                MobEffectInstance mobeffectinstance = new MobEffectInstance(mobeffect, packet.duration(), (int)packet.amplifier(), packet.isEffectAmbient(), packet.isEffectVisible(), packet.effectShowsIcon());
                                living.m_147215_(mobeffectinstance, null);
                            }
                        }
                    }
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

