/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.citadel.server.message.PacketBufferUtils;
import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.network.NetworkEvent;

public record UpdateRatFluidPacket(int ratId, FluidStack fluid) {
    public static UpdateRatFluidPacket decode(FriendlyByteBuf buf) {
        return new UpdateRatFluidPacket(buf.readInt(), FluidStack.loadFluidStackFromNBT((CompoundTag)PacketBufferUtils.readTag((ByteBuf)buf)));
    }

    public static void encode(UpdateRatFluidPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.ratId);
        CompoundTag fluidTag = new CompoundTag();
        if (packet.fluid != null) {
            packet.fluid.writeToNBT(fluidTag);
        }
        PacketBufferUtils.writeTag((ByteBuf)buf, (CompoundTag)fluidTag);
    }

    public static class Handler {
        public static void handle(UpdateRatFluidPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
                if (player != null && (entity = player.m_9236_().m_6815_(packet.ratId())) instanceof TamedRat) {
                    TamedRat rat = (TamedRat)entity;
                    rat.transportingFluid = packet.fluid();
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

