/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.misc;

import com.github.alexthe666.rats.server.entity.rat.TamedRat;
import com.github.alexthe666.rats.server.items.upgrades.BaseRatUpgradeItem;
import com.github.alexthe666.rats.server.items.upgrades.interfaces.CombinedUpgrade;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RatUpgradeUtils {
    public static final EquipmentSlot[] UPGRADE_SLOTS = new EquipmentSlot[]{EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};

    public static ItemStack getUpgrade(TamedRat rat, Item item) {
        for (EquipmentSlot slot : UPGRADE_SLOTS) {
            ItemStack stack = rat.m_6844_(slot);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() == item) {
                return stack;
            }
            Item item2 = stack.m_41720_();
            if (!(item2 instanceof CombinedUpgrade)) continue;
            CombinedUpgrade combined = (CombinedUpgrade)item2;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128425_("Items", 9)) continue;
            NonNullList upgradeList = NonNullList.m_122780_((int)combined.getUpgradeSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)upgradeList);
            for (ItemStack selectedUpgrade : upgradeList) {
                if (selectedUpgrade.m_41720_() != item) continue;
                return selectedUpgrade;
            }
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasUpgrade(TamedRat rat, Item item) {
        if (rat.hasAnyUpgrades()) {
            return RatUpgradeUtils.getUpgrade(rat, item) != ItemStack.f_41583_;
        }
        return false;
    }

    public static void forEachUpgrade(TamedRat rat, Predicate<Item> upgrade, BiConsumer<ItemStack, EquipmentSlot> function) {
        for (EquipmentSlot slot : UPGRADE_SLOTS) {
            Item item;
            ItemStack stack = rat.m_6844_(slot);
            if (stack.m_41619_()) continue;
            if (upgrade.test(stack.m_41720_())) {
                function.accept(stack, slot);
            }
            if (!((item = stack.m_41720_()) instanceof CombinedUpgrade)) continue;
            CombinedUpgrade combined = (CombinedUpgrade)item;
            CompoundTag tag = stack.m_41783_();
            if (tag == null || !tag.m_128425_("Items", 9)) continue;
            NonNullList upgradeList = NonNullList.m_122780_((int)combined.getUpgradeSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)upgradeList);
            for (ItemStack selectedUpgrade : upgradeList) {
                if (!upgrade.test(selectedUpgrade.m_41720_())) continue;
                function.accept(selectedUpgrade, slot);
            }
        }
    }

    public static boolean forEachUpgradeBool(TamedRat rat, Function<BaseRatUpgradeItem, Boolean> function, boolean def) {
        for (EquipmentSlot slot : UPGRADE_SLOTS) {
            BaseRatUpgradeItem upgrade;
            ItemStack stack = rat.m_6844_(slot);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof CombinedUpgrade) {
                CombinedUpgrade combined = (CombinedUpgrade)item;
                CompoundTag tag = stack.m_41783_();
                if (tag == null || !tag.m_128425_("Items", 9)) continue;
                NonNullList upgradeList = NonNullList.m_122780_((int)combined.getUpgradeSlots(), (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)upgradeList);
                for (ItemStack selectedUpgrade : upgradeList) {
                    BaseRatUpgradeItem upgrade2;
                    Item item2 = selectedUpgrade.m_41720_();
                    if (!(item2 instanceof BaseRatUpgradeItem) || function.apply(upgrade2 = (BaseRatUpgradeItem)item2) == def) continue;
                    return function.apply(upgrade2);
                }
                continue;
            }
            item = stack.m_41720_();
            if (!(item instanceof BaseRatUpgradeItem) || function.apply(upgrade = (BaseRatUpgradeItem)item) == def) continue;
            return function.apply(upgrade);
        }
        return def;
    }
}

