/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.world;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.registry.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.misc.PlagueDoctor;
import com.github.alexthe666.rats.server.entity.rat.Rat;
import com.github.alexthe666.rats.server.world.PlagueDoctorWorldData;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class PlagueDoctorSpawner
implements CustomSpawner {
    private int tickDelay = 1200;
    private int spawnDelay;
    private int spawnChance;

    public PlagueDoctorSpawner(ServerLevel level) {
        PlagueDoctorWorldData worldinfo = PlagueDoctorWorldData.get((Level)level);
        this.spawnDelay = worldinfo.getDoctorSpawnDelay();
        this.spawnChance = worldinfo.getDoctorSpawnChance();
        if (this.spawnDelay == 0 && this.spawnChance == 0) {
            this.spawnDelay = 24000;
            worldinfo.setDoctorSpawnDelay(this.spawnDelay);
            this.spawnChance = 25;
            worldinfo.setDoctorSpawnChance(this.spawnChance);
        }
    }

    public int m_7995_(ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (level.m_46469_().m_46207_(RatsMod.SPAWN_PLAGUE_DOCTORS) && this.tickDelay-- <= 0) {
            this.tickDelay = 1200;
            PlagueDoctorWorldData data = PlagueDoctorWorldData.get((Level)level);
            if (data != null) {
                this.spawnDelay -= 1200;
                data.setDoctorSpawnDelay(this.spawnDelay);
                if (this.spawnDelay <= 0) {
                    this.spawnDelay = 24000;
                    if (level.m_46469_().m_46207_(GameRules.f_46134_)) {
                        int i = this.spawnChance;
                        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + 25), (int)25, (int)75);
                        data.setDoctorSpawnChance(this.spawnChance);
                        if (level.m_213780_().m_188503_(100) <= i && this.canSpawnDoctor(level)) {
                            this.spawnChance = 25;
                            data.m_77762_();
                            return 1;
                        }
                    }
                }
            }
        }
        return 0;
    }

    private boolean canSpawnDoctor(ServerLevel level) {
        ServerPlayer player = level.m_8890_();
        if (player == null) {
            return true;
        }
        if (level.m_213780_().m_188503_(5) != 0) {
            return false;
        }
        BlockPos blockpos = player.m_20183_();
        PoiManager poimanager = level.m_8904_();
        Optional optional = poimanager.m_27186_(poiTypeHolder -> poiTypeHolder.m_203565_(PoiTypes.f_218061_), pos -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findNearbySpawnPos(level, blockpos1, 48);
        if (blockpos2 != null && this.hasSpace((BlockGetter)level, blockpos2)) {
            if (level.m_204166_(blockpos2).m_203656_(BiomeTags.f_215807_)) {
                return false;
            }
            PlagueDoctor plagueDoctor = (PlagueDoctor)((EntityType)RatsEntityRegistry.PLAGUE_DOCTOR.get()).m_262496_(level, blockpos2, MobSpawnType.EVENT);
            if (plagueDoctor != null) {
                for (int j = 0; j < 2; ++j) {
                    this.spawnARat(level, plagueDoctor);
                }
                PlagueDoctorWorldData data = PlagueDoctorWorldData.get((Level)level);
                if (data != null) {
                    data.setPlagueDoctorID(plagueDoctor.m_20148_());
                    plagueDoctor.setWillDespawn(true);
                    plagueDoctor.setDespawnDelay(24000);
                    plagueDoctor.setWanderTarget(blockpos1);
                    plagueDoctor.m_21446_(blockpos1, 32);
                    return true;
                }
            }
        }
        return false;
    }

    private void spawnARat(ServerLevel level, PlagueDoctor doctor) {
        Rat rat;
        BlockPos blockpos = this.findNearbySpawnPos(level, doctor.m_20183_(), 4);
        if (blockpos != null && (rat = (Rat)((EntityType)RatsEntityRegistry.RAT.get()).m_262496_(level, blockpos, MobSpawnType.EVENT)) != null) {
            rat.m_21463_((Entity)doctor, true);
            rat.setPlagued(false);
            rat.m_21816_(doctor.m_20148_());
        }
    }

    @Nullable
    private BlockPos findNearbySpawnPos(ServerLevel level, BlockPos pos, int distance) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pos.m_123341_() + level.m_213780_().m_188503_(distance * 2) - distance;
            BlockPos blockpos1 = new BlockPos(j, l = level.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pos.m_123343_() + level.m_213780_().m_188503_(distance * 2) - distance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)level, (BlockPos)blockpos1, (EntityType)EntityType.f_20494_)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasSpace(BlockGetter getter, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos, (BlockPos)pos.m_7918_(1, 2, 1))) {
            if (getter.m_8055_(blockpos).m_60812_(getter, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

