/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer;

import dev.architectury.platform.Platform;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.jonko0493.computercartographer.block.ComputerizedCartographerBlock;
import net.jonko0493.computercartographer.block.ComputerizedCartographerBlockEntity;
import net.jonko0493.computercartographer.integration.BlueMapIntegration;
import net.jonko0493.computercartographer.integration.DynmapIntegration;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.Pl3xMapIntegration;
import net.jonko0493.computercartographer.integration.SquaremapIntegration;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputerCartographer {
    public static final String MOD_ID = "computer_cartographer";
    public static List<IMapIntegration> integrations = new ArrayList<IMapIntegration>();
    public static final Logger Log = LoggerFactory.getLogger((String)"computer_cartographer");
    public static DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"computer_cartographer", (ResourceKey)Registries.f_256913_);
    public static DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"computer_cartographer", (ResourceKey)Registries.f_256747_);
    public static Map<RegistrySupplier<? extends Block>, Item.Properties> BLOCK_ITEMS = new HashMap<RegistrySupplier<? extends Block>, Item.Properties>();
    public static DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((String)"computer_cartographer", (ResourceKey)Registries.f_256922_);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"computercraft", (ResourceKey)Registries.f_279569_);
    public static RegistrySupplier<ComputerizedCartographerBlock> COMPUTERIZED_CARTOGRAPHER_BLOCK = ComputerCartographer.registerBlockItem("computerized_cartographer", () -> new ComputerizedCartographerBlock(BlockBehaviour.Properties.m_284310_().m_155954_(1.3f)));
    public static RegistrySupplier<BlockEntityType<ComputerizedCartographerBlockEntity>> COMPUTERIZED_CARTOGRAPHER_BLOCK_ENTITY = BLOCK_ENTITIES.register("computerized_cartographer_block_entity", () -> BlockEntityType.Builder.m_155273_(ComputerizedCartographerBlockEntity::new, (Block[])new Block[]{(Block)COMPUTERIZED_CARTOGRAPHER_BLOCK.get()}).m_58966_(null));

    public static void log(String message) {
        Log.info(message);
    }

    public static void logWarning(String message) {
        Log.warn(message);
    }

    public static void logException(Exception e) {
        Log.error(e.getMessage());
        Log.error(String.join((CharSequence)"\n", (CharSequence[])Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).toArray(String[]::new)));
    }

    public static <T extends Block> RegistrySupplier<T> registerBlock(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(String name, Supplier<T> item) {
        return ITEMS.register(name, item);
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockItem(String name, Supplier<T> block) {
        return ComputerCartographer.registerBlockItem(name, block, new Item.Properties());
    }

    public static <T extends Block> RegistrySupplier<T> registerBlockItem(String name, Supplier<T> block, Item.Properties props) {
        RegistrySupplier<T> blockRegistered = ComputerCartographer.registerBlock(name, block);
        BLOCK_ITEMS.put(blockRegistered, props);
        return blockRegistered;
    }

    public static void init() {
        ComputerCartographer.initIntegrations();
        BLOCKS.register();
        BLOCK_ITEMS.forEach((block, itemprops) -> {
            RegistrySupplier blockItem = ITEMS.register(block.getId(), () -> new BlockItem((Block)block.get(), itemprops));
            CreativeTabRegistry.append((ResourceKey)ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)new ResourceLocation("computercraft:tab")), (Supplier[])new RegistrySupplier[]{blockItem});
        });
        ITEMS.register();
        BLOCK_ENTITIES.register();
    }

    public static void initIntegrations() {
        SquaremapIntegration squaremapIntegration;
        Pl3xMapIntegration pl3xMapIntegration;
        DynmapIntegration dynmapIntegration;
        BlueMapIntegration blueMapIntegration;
        Log.atInfo().log("Attempting to add computer cartographer integrations...");
        integrations.clear();
        if (Platform.isModLoaded((String)"bluemap") && (blueMapIntegration = new BlueMapIntegration()).init()) {
            ComputerCartographer.log("Registered BlueMap integration!");
            integrations.add(blueMapIntegration);
        }
        if (Platform.isModLoaded((String)"dynmap") && (dynmapIntegration = new DynmapIntegration()).init()) {
            ComputerCartographer.log("Registered Dynmap integration!");
            integrations.add(dynmapIntegration);
        }
        if (Platform.isModLoaded((String)"pl3xmap") && (pl3xMapIntegration = new Pl3xMapIntegration()).init()) {
            ComputerCartographer.log("Registered Pl3xMap integration!");
            integrations.add(pl3xMapIntegration);
        }
        if (Platform.isModLoaded((String)"squaremap") && (squaremapIntegration = new SquaremapIntegration()).init()) {
            ComputerCartographer.log("Registered Squaremap integration!");
            integrations.add(squaremapIntegration);
        }
    }
}

