/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.integration;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.api.BlueMapAPI;
import de.bluecolored.bluemap.api.BlueMapMap;
import de.bluecolored.bluemap.api.markers.ExtrudeMarker;
import de.bluecolored.bluemap.api.markers.LineMarker;
import de.bluecolored.bluemap.api.markers.Marker;
import de.bluecolored.bluemap.api.markers.MarkerSet;
import de.bluecolored.bluemap.api.markers.POIMarker;
import de.bluecolored.bluemap.api.markers.ShapeMarker;
import de.bluecolored.bluemap.api.math.Line;
import de.bluecolored.bluemap.api.math.Shape;
import java.awt.Color;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import net.jonko0493.computercartographer.ComputerCartographer;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.IntegrationHelper;
import org.apache.commons.io.FilenameUtils;

public class BlueMapIntegration
implements IMapIntegration {
    private final String name = "bluemap";
    private BlueMapAPI api;
    private BlueMapMap currentMap;
    private boolean enabled = false;

    private static de.bluecolored.bluemap.api.math.Color convertFromAwt(Color color) {
        return new de.bluecolored.bluemap.api.math.Color(color.getRed(), color.getGreen(), color.getBlue(), (float)color.getAlpha() / 255.0f);
    }

    @Override
    public boolean init() {
        try {
            BlueMapAPI.getInstance().ifPresent(api -> {
                this.api = api;
                api.getMap("overworld").ifPresent(map -> {
                    this.currentMap = map;
                });
                if (this.currentMap == null) {
                    api.getMaps().stream().findFirst().ifPresent(map -> {
                        this.currentMap = map;
                    });
                }
                this.enabled = true;
                if (this.currentMap == null) {
                    ComputerCartographer.logWarning("No BlueMap maps found! Disabling BlueMap integration");
                    this.enabled = false;
                }
            });
        }
        catch (IllegalStateException | NoClassDefFoundError ignore) {
            ComputerCartographer.log("BlueMap is not loaded.");
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return "bluemap";
    }

    @Override
    public String[] getAvailableMaps() {
        if (this.enabled) {
            try {
                return (String[])this.api.getMaps().stream().map(BlueMapMap::getName).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public String getCurrentMap() {
        if (this.enabled) {
            try {
                return this.currentMap.getId();
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean setCurrentMap(String world) {
        if (this.enabled) {
            try {
                this.api.getMap(world.toLowerCase()).ifPresent(map -> {
                    this.currentMap = map;
                });
                return this.currentMap.getId().equalsIgnoreCase(world);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addMarkerSet(String setName, String label) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.currentMap.getMarkerSets().put(setName, new MarkerSet(label, true, false));
                return this.currentMap.getMarkerSets().containsKey(setName);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.currentMap.getMarkerSets().remove(setName);
                return !this.currentMap.getMarkerSets().containsKey(setName);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public String[] getMarkerSets() {
        if (this.enabled) {
            try {
                return (String[])this.currentMap.getMarkerSets().keySet().stream().filter(s -> s.startsWith("cc_")).map(s -> s.substring(3)).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean clearMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                if (this.currentMap.getMarkerSets().containsKey(setName)) {
                    ((MarkerSet)this.currentMap.getMarkerSets().get(setName)).getMarkers().clear();
                    return ((MarkerSet)this.currentMap.getMarkerSets().get(setName)).getMarkers().isEmpty();
                }
                ComputerCartographer.logWarning("Attempted to clear markers from non-existent set '" + (String)setName + "'");
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addPOIMarker(String markerSet, String id, String label, String detail, String icon, double x, double y, double z) {
        if (!this.enabled) return false;
        try {
            String realIcon;
            block21: {
                markerSet = "cc_" + (String)markerSet;
                if (!this.currentMap.getMarkerSets().containsKey(markerSet)) {
                    ComputerCartographer.logWarning("Attempted to add POI marker to non-existent set '" + (String)markerSet + "'");
                    return false;
                }
                realIcon = "";
                if (icon.startsWith("http")) {
                    try {
                        URL url = new URL(icon);
                        String iconFileName = "cc_" + FilenameUtils.removeExtension((String)FilenameUtils.getBaseName((String)url.getFile().toLowerCase())) + ".png";
                        if (this.currentMap.getAssetStorage().assetExists(iconFileName)) {
                            realIcon = this.currentMap.getAssetStorage().getAssetUrl(iconFileName);
                            break block21;
                        }
                        try (OutputStream out = this.currentMap.getAssetStorage().writeAsset(iconFileName);){
                            if (!IntegrationHelper.downloadAndResizeIcon(url, out)) {
                                ComputerCartographer.logWarning("Failed to download icon for POI marker!");
                                boolean bl = false;
                                return bl;
                            }
                            realIcon = this.currentMap.getAssetStorage().getAssetUrl(iconFileName);
                            break block21;
                        }
                        catch (Exception e) {
                            ComputerCartographer.logException(e);
                            return false;
                        }
                    }
                    catch (Exception e) {
                        ComputerCartographer.logException(e);
                        return false;
                    }
                }
                String iconName = "cc_" + icon.toLowerCase() + ".png";
                if (this.currentMap.getAssetStorage().assetExists(iconName)) {
                    realIcon = this.currentMap.getAssetStorage().getAssetUrl(iconName);
                } else {
                    ComputerCartographer.logWarning("Attempted to use icon " + icon + " which does not exist.");
                }
            }
            POIMarker.Builder markerBuilder = POIMarker.builder();
            if (realIcon.isEmpty()) {
                markerBuilder.defaultIcon();
            } else {
                markerBuilder.icon(realIcon, 12, 12);
            }
            POIMarker marker = ((POIMarker.Builder)((POIMarker.Builder)markerBuilder.label(label)).detail(detail).position(x, y, z)).build();
            ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)marker);
            return true;
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
        }
        return false;
    }

    @Override
    public boolean addLineMarker(String markerSet, String id, String label, String detail, Color color, int width, ArrayList<org.joml.Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                if (this.currentMap.getMarkerSets().containsKey(markerSet)) {
                    Line.Builder lineBuilder = Line.builder();
                    for (org.joml.Vector3d point : points) {
                        lineBuilder.addPoint(new Vector3d(point.x, point.y, point.z));
                    }
                    LineMarker lineMarker = ((LineMarker.Builder)((LineMarker.Builder)LineMarker.builder().line(lineBuilder.build()).centerPosition().label(label)).detail(detail)).lineColor(BlueMapIntegration.convertFromAwt(color)).lineWidth(width).depthTestEnabled(false).build();
                    ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)lineMarker);
                    return true;
                }
                ComputerCartographer.logWarning("Attempted to remove marker from non-existent set '" + (String)markerSet + "'");
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addCircleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x, double y, double z, double radius) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                if (this.currentMap.getMarkerSets().containsKey(markerSet)) {
                    Shape circle = Shape.createCircle((double)x, (double)z, (double)radius, (int)((int)Math.max(10.0, Math.min(100.0, radius))));
                    ShapeMarker circleMarker = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().shape(circle, (float)y).centerPosition().label(label)).detail(detail)).lineColor(BlueMapIntegration.convertFromAwt(lineColor)).fillColor(BlueMapIntegration.convertFromAwt(fillColor)).lineWidth(lineWidth).depthTestEnabled(false).build();
                    ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)circleMarker);
                    return true;
                }
                ComputerCartographer.logWarning("Attempted to add circle marker to non-existent set '" + (String)markerSet + "'");
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addRectangleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x1, double z1, double x2, double z2) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                if (this.currentMap.getMarkerSets().containsKey(markerSet)) {
                    Shape rectangle = Shape.createRect((double)x1, (double)z1, (double)x2, (double)z2);
                    ShapeMarker rectangleMarker = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().shape(rectangle, 63.0f).centerPosition().label(label)).detail(detail)).lineColor(BlueMapIntegration.convertFromAwt(lineColor)).fillColor(BlueMapIntegration.convertFromAwt(fillColor)).lineWidth(lineWidth).depthTestEnabled(false).build();
                    ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)rectangleMarker);
                    return true;
                }
                ComputerCartographer.logWarning("Attempted to add rectangle marker to non-existent set '" + (String)markerSet + "'");
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addAreaMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, ArrayList<org.joml.Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                if (this.currentMap.getMarkerSets().containsKey(markerSet)) {
                    Shape.Builder shapeBuilder = Shape.builder();
                    for (org.joml.Vector3d point : points) {
                        shapeBuilder.addPoint(new Vector2d(point.x, point.z));
                    }
                    if (points.stream().allMatch(p -> p.y == ((org.joml.Vector3d)points.get((int)0)).y)) {
                        ShapeMarker shapeMarker = ((ShapeMarker.Builder)((ShapeMarker.Builder)ShapeMarker.builder().shape(shapeBuilder.build(), (float)points.get((int)0).y).centerPosition().label(label)).detail(detail)).lineColor(BlueMapIntegration.convertFromAwt(lineColor)).fillColor(BlueMapIntegration.convertFromAwt(fillColor)).lineWidth(lineWidth).depthTestEnabled(false).build();
                        ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)shapeMarker);
                        return true;
                    }
                    ExtrudeMarker extrudeMarker = ((ExtrudeMarker.Builder)((ExtrudeMarker.Builder)ExtrudeMarker.builder().shape(shapeBuilder.build(), points.stream().map(v -> v.y).min(Double::compare).get().floatValue(), points.stream().map(v -> v.y).max(Double::compare).get().floatValue()).centerPosition().label(label)).detail(detail)).lineColor(BlueMapIntegration.convertFromAwt(lineColor)).fillColor(BlueMapIntegration.convertFromAwt(fillColor)).lineWidth(lineWidth).depthTestEnabled(false).build();
                    ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).put(id, (Marker)extrudeMarker);
                    return true;
                }
                ComputerCartographer.logWarning("Attempted to add area marker to non-existent set '" + (String)markerSet + "'");
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarker(String markerSet, String id) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                return ((MarkerSet)this.currentMap.getMarkerSets().get(markerSet)).remove(id) != null;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }
}

