/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.integration;

import java.awt.Color;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import net.jonko0493.computercartographer.ComputerCartographer;
import net.jonko0493.computercartographer.MinecraftServerGetter;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.IntegrationHelper;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.commons.io.FilenameUtils;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.DynmapCommonAPIListener;
import org.dynmap.markers.AreaMarker;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.PolyLineMarker;
import org.joml.Vector3d;

public class DynmapIntegration
implements IMapIntegration {
    private final String name = "dynmap";
    private static DynmapCommonAPI dynmapAPI;
    private static MarkerAPI markerAPI;
    private boolean enabled = false;
    private String currentMap;

    @Override
    public boolean init() {
        boolean bl = this.enabled = dynmapAPI != null;
        if (this.enabled) {
            markerAPI = dynmapAPI.getMarkerAPI();
            if (this.currentMap == null) {
                String[] availableMaps = this.getAvailableMaps();
                this.currentMap = availableMaps[availableMaps.length - 1];
            }
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return "dynmap";
    }

    @Override
    public String[] getAvailableMaps() {
        Path savePath = MinecraftServerGetter.getServerInstance().m_129843_(LevelResource.f_78182_);
        savePath = savePath.getParent();
        return (String[])IntegrationHelper.getDirectoriesWithRegionDirectory(savePath.toFile()).toArray(String[]::new);
    }

    @Override
    public String getCurrentMap() {
        if (this.enabled) {
            return this.currentMap;
        }
        return null;
    }

    @Override
    public boolean setCurrentMap(String world) {
        if (this.enabled && Arrays.stream(this.getAvailableMaps()).anyMatch(m -> m.equalsIgnoreCase(world))) {
            this.currentMap = world;
            return true;
        }
        return false;
    }

    @Override
    public boolean addMarkerSet(String setName, String label) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                markerAPI.createMarkerSet((String)setName, label, null, false);
                return markerAPI.getMarkerSet((String)setName) != null;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                markerAPI.getMarkerSet((String)setName).deleteMarkerSet();
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public String[] getMarkerSets() {
        if (this.enabled) {
            try {
                return (String[])markerAPI.getMarkerSets().stream().map(MarkerSet::getMarkerSetID).filter(s -> s.startsWith("cc_")).map(m -> m.substring(3)).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean clearMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                MarkerSet markerSet = markerAPI.getMarkerSet((String)setName);
                for (Marker marker : markerSet.getMarkers()) {
                    marker.deleteMarker();
                }
                for (PolyLineMarker lineMarker : markerSet.getPolyLineMarkers()) {
                    lineMarker.deleteMarker();
                }
                for (CircleMarker circleMarker : markerSet.getCircleMarkers()) {
                    circleMarker.deleteMarker();
                }
                for (AreaMarker areaMarker : markerSet.getAreaMarkers()) {
                    areaMarker.deleteMarker();
                }
                return markerSet.getMarkers().isEmpty() && markerSet.getPolyLineMarkers().isEmpty() && markerSet.getCircleMarkers().isEmpty() && markerSet.getAreaMarkers().isEmpty();
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addPOIMarker(String markerSet, String id, String label, String detail, String icon, double x, double y, double z) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Object realIcon = "";
                if (!icon.isEmpty()) {
                    URL iconUrl = null;
                    if (icon.startsWith("http")) {
                        iconUrl = new URL(icon);
                        realIcon = "cc_" + FilenameUtils.removeExtension((String)FilenameUtils.getBaseName((String)iconUrl.getFile().toLowerCase()));
                    }
                    String iconCompare = realIcon;
                    if (markerAPI.getMarkerIcons().stream().noneMatch(i -> i.getMarkerIconID().equals(iconCompare))) {
                        if (iconUrl != null) {
                            markerAPI.createMarkerIcon((String)realIcon, (String)realIcon, IntegrationHelper.downloadAndResizeIcon(iconUrl));
                        } else {
                            realIcon = markerAPI.getMarkerIcon(icon) != null ? icon : (markerAPI.getMarkerIcon("cc_" + icon) != null ? "cc_" + icon : "");
                        }
                    }
                }
                String htmlLabel = "<div>" + label + "</div>" + detail;
                MarkerIcon markerIcon = ((String)realIcon).isEmpty() ? null : markerAPI.getMarkerIcon((String)realIcon);
                markerAPI.getMarkerSet((String)markerSet).createMarker(id, htmlLabel, true, this.currentMap, x, y, z, markerIcon, false);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addLineMarker(String markerSet, String id, String label, String detail, Color color, int width, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                String htmlLabel = "<div>" + label + "</div>" + detail;
                PolyLineMarker lineMarker = markerAPI.getMarkerSet((String)markerSet).createPolyLineMarker(id, htmlLabel, true, this.currentMap, DynmapIntegration.getXCoords(points), DynmapIntegration.getYCoords(points), DynmapIntegration.getZCoords(points), false);
                lineMarker.setLineStyle(width, (double)color.getAlpha() / 255.0, color.getRGB() & 0xFFFFFF);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addCircleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x, double y, double z, double radius) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                String htmlLabel = "<div>" + label + "</div>" + detail;
                CircleMarker circleMarker = markerAPI.getMarkerSet((String)markerSet).createCircleMarker(id, htmlLabel, true, this.currentMap, x, y, z, radius, radius, false);
                circleMarker.setLineStyle(lineWidth, (double)lineColor.getAlpha() / 255.0, lineColor.getRGB() & 0xFFFFFF);
                circleMarker.setFillStyle((double)fillColor.getAlpha() / 255.0, fillColor.getRGB() & 0xFFFFFF);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addRectangleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x1, double z1, double x2, double z2) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                String htmlLabel = "<div>" + label + "</div>" + detail;
                double[] xCoords = new double[]{x1, x2};
                double[] zCoords = new double[]{z1, z2};
                AreaMarker rectangleMarker = markerAPI.getMarkerSet((String)markerSet).createAreaMarker(id, htmlLabel, true, this.currentMap, xCoords, zCoords, false);
                rectangleMarker.setLineStyle(lineWidth, (double)lineColor.getAlpha() / 255.0, lineColor.getRGB() & 0xFFFFFF);
                rectangleMarker.setFillStyle((double)fillColor.getAlpha() / 255.0, fillColor.getRGB() & 0xFFFFFF);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addAreaMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                String htmlLabel = "<div>" + label + "</div>" + detail;
                AreaMarker areaMarker = markerAPI.getMarkerSet((String)markerSet).createAreaMarker(id, htmlLabel, true, this.currentMap, DynmapIntegration.getXCoords(points), DynmapIntegration.getZCoords(points), false);
                areaMarker.setLineStyle(lineWidth, (double)lineColor.getAlpha() / 255.0, lineColor.getRGB() & 0xFFFFFF);
                areaMarker.setFillStyle((double)fillColor.getAlpha() / 255.0, fillColor.getRGB() & 0xFFFFFF);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarker(String markerSet, String id) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                MarkerSet markers = markerAPI.getMarkerSet((String)markerSet);
                Marker marker = markers.findMarker(id);
                if (marker != null) {
                    marker.deleteMarker();
                    return true;
                }
                PolyLineMarker lineMarker = markers.findPolyLineMarker(id);
                if (lineMarker != null) {
                    lineMarker.deleteMarker();
                    return true;
                }
                CircleMarker circleMarker = markers.findCircleMarker(id);
                if (circleMarker != null) {
                    circleMarker.deleteMarker();
                    return true;
                }
                AreaMarker areaMarker = markers.findAreaMarker(id);
                if (areaMarker != null) {
                    areaMarker.deleteMarker();
                    return true;
                }
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    private static double[] getXCoords(ArrayList<Vector3d> points) {
        double[] xArray = new double[points.size()];
        for (int i = 0; i < xArray.length; ++i) {
            xArray[i] = points.get((int)i).x;
        }
        return xArray;
    }

    private static double[] getYCoords(ArrayList<Vector3d> points) {
        double[] yArray = new double[points.size()];
        for (int i = 0; i < yArray.length; ++i) {
            yArray[i] = points.get((int)i).y;
        }
        return yArray;
    }

    private static double[] getZCoords(ArrayList<Vector3d> points) {
        double[] zArray = new double[points.size()];
        for (int i = 0; i < zArray.length; ++i) {
            zArray[i] = points.get((int)i).z;
        }
        return zArray;
    }

    static {
        try {
            DynmapCommonAPIListener.register((DynmapCommonAPIListener)new DynmapCommonAPIListener(){

                public void apiEnabled(DynmapCommonAPI dynmapCommonAPI) {
                    dynmapAPI = dynmapCommonAPI;
                }
            });
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
        }
    }
}

