/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.integration;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.imageio.ImageIO;
import net.jonko0493.computercartographer.ComputerCartographer;
import org.apache.commons.lang3.StringEscapeUtils;
import org.joml.Vector3d;

public class IntegrationHelper {
    public static final int ICON_WIDTH = 24;
    public static final int ICON_HEIGHT = 24;

    public static String sanitizeHtml(String html) {
        return StringEscapeUtils.escapeHtml4((String)html);
    }

    public static BufferedImage downloadAndResizeIconBufferedImage(URL url) {
        try {
            BufferedImage icon = ImageIO.read(url);
            if (icon == null) {
                return null;
            }
            BufferedImage resizedIcon = new BufferedImage(24, 24, 2);
            Graphics2D g2d = resizedIcon.createGraphics();
            g2d.addRenderingHints(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
            g2d.drawImage(icon, 0, 0, 24, 24, null);
            return resizedIcon;
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
            return null;
        }
    }

    public static InputStream downloadAndResizeIcon(URL url) {
        BufferedImage resizedIcon = IntegrationHelper.downloadAndResizeIconBufferedImage(url);
        if (resizedIcon != null) {
            try {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)resizedIcon, "png", outStream);
                return new ByteArrayInputStream(outStream.toByteArray());
            }
            catch (IOException e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    public static boolean downloadAndResizeIcon(URL url, OutputStream output) {
        try {
            BufferedImage resizedIcon = IntegrationHelper.downloadAndResizeIconBufferedImage(url);
            if (resizedIcon != null) {
                ImageIO.write((RenderedImage)resizedIcon, "png", output);
                output.flush();
                output.close();
                return true;
            }
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
        }
        return false;
    }

    public static ArrayList<String> getDirectoriesWithRegionDirectory(File dir) {
        ArrayList<String> matches = new ArrayList<String>();
        return IntegrationHelper.getDirectoriesWithRegionDirectory(dir, matches);
    }

    public static ArrayList<String> getDirectoriesWithRegionDirectory(File dir, ArrayList<String> matches) {
        File[] ls = dir.listFiles();
        for (File file : Objects.requireNonNull(ls)) {
            if (file.isDirectory() && file.getName().equals("region")) {
                matches.add(file.getParentFile().getName());
                continue;
            }
            if (!file.isDirectory()) continue;
            IntegrationHelper.getDirectoriesWithRegionDirectory(file, matches);
        }
        return matches;
    }

    public static Vector3d parsePoint(Map<?, ?> table) {
        if (!(table != null && table.containsKey("x") && table.containsKey("y") && table.containsKey("z"))) {
            return null;
        }
        return new Vector3d((double)((Number)table.get("x")).intValue(), (double)((Number)table.get("y")).intValue(), (double)((Number)table.get("z")).intValue());
    }

    public static ArrayList<Vector3d> parsePoints(Map<?, ?> table) {
        ArrayList<Vector3d> points = new ArrayList<Vector3d>();
        double i = 1.0;
        while (table.containsKey(i)) {
            Vector3d point = IntegrationHelper.parsePoint((Map)table.get(i));
            if (point != null) {
                points.add(point);
            }
            i += 1.0;
        }
        return points;
    }
}

