/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.integration;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jonko0493.computercartographer.ComputerCartographer;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.IntegrationHelper;
import net.pl3x.map.core.Keyed;
import net.pl3x.map.core.Pl3xMap;
import net.pl3x.map.core.image.IconImage;
import net.pl3x.map.core.markers.Point;
import net.pl3x.map.core.markers.layer.SimpleLayer;
import net.pl3x.map.core.markers.marker.Circle;
import net.pl3x.map.core.markers.marker.Icon;
import net.pl3x.map.core.markers.marker.Marker;
import net.pl3x.map.core.markers.marker.Polygon;
import net.pl3x.map.core.markers.marker.Polyline;
import net.pl3x.map.core.markers.marker.Rectangle;
import net.pl3x.map.core.markers.option.Options;
import net.pl3x.map.core.world.World;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;

public class Pl3xMapIntegration
implements IMapIntegration {
    private final String name = "pl3xmap";
    private Pl3xMap pl3xMapApi;
    private boolean enabled;
    private World currentMap;
    private final Map<String, CCLayer> layers = new HashMap<String, CCLayer>();

    @Override
    public boolean init() {
        try {
            this.pl3xMapApi = Pl3xMap.api();
            this.enabled = true;
        }
        catch (Exception e) {
            ComputerCartographer.log("Pl3xMap is not loaded");
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return "pl3xmap";
    }

    @Override
    public String[] getAvailableMaps() {
        if (this.enabled) {
            try {
                ArrayList<String> mapNames = new ArrayList<String>();
                for (World world : this.pl3xMapApi.getWorldRegistry()) {
                    mapNames.add(world.getName());
                }
                return (String[])mapNames.toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public String getCurrentMap() {
        if (this.enabled) {
            return this.currentMap.getName();
        }
        return null;
    }

    @Override
    public boolean setCurrentMap(String world) {
        if (Arrays.stream(this.getAvailableMaps()).anyMatch(m -> m.equalsIgnoreCase(world))) {
            this.currentMap = (World)this.pl3xMapApi.getWorldRegistry().get(world);
            return true;
        }
        return false;
    }

    @Override
    public boolean addMarkerSet(String setName, String label) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                CCLayer layer = new CCLayer((String)setName, label, this.currentMap);
                this.currentMap.getLayerRegistry().register((String)setName, (Keyed)layer);
                this.layers.put((String)setName, layer);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.currentMap.getLayerRegistry().unregister((String)setName);
                this.layers.remove(setName);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public String[] getMarkerSets() {
        if (this.enabled) {
            try {
                return (String[])this.layers.keySet().stream().map(k -> k.substring(3)).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean clearMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.layers.get((Object)setName).markers.clear();
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addPOIMarker(String markerSet, String id, String label, String detail, String icon, double x, double y, double z) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Object realIcon = "";
                if (!icon.isEmpty()) {
                    URL iconUrl = null;
                    if (icon.startsWith("http")) {
                        iconUrl = new URL(icon);
                        realIcon = "cc_" + FilenameUtils.removeExtension((String)FilenameUtils.getBaseName((String)iconUrl.getFile().toLowerCase()));
                    }
                    String iconCompare = realIcon;
                    ArrayList<String> iconNames = new ArrayList<String>();
                    for (IconImage iconImage : this.pl3xMapApi.getIconRegistry()) {
                        iconNames.add(iconImage.getKey());
                    }
                    if (iconNames.stream().noneMatch(i -> i.equals(iconCompare))) {
                        if (iconUrl != null) {
                            this.pl3xMapApi.getIconRegistry().register((String)realIcon, new IconImage((String)realIcon, Objects.requireNonNull(IntegrationHelper.downloadAndResizeIconBufferedImage(iconUrl)), "png"));
                        } else {
                            realIcon = this.pl3xMapApi.getIconRegistry().get(icon) != null ? icon : (this.pl3xMapApi.getIconRegistry().get("cc_" + icon) != null ? "cc_" + icon : "");
                        }
                    }
                    Icon iconMarker = new Icon(id, x, z, (String)realIcon);
                    iconMarker.setOptions(new Options.Builder().popupContent("<div>" + label + "</div>" + detail).tooltipContent(label).build());
                    this.layers.get((Object)markerSet).markers.add((Marker<?>)iconMarker);
                    return true;
                }
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addLineMarker(String markerSet, String id, String label, String detail, Color color, int width, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                List<Point> pl3xPoints = points.stream().map(p -> new Point((int)p.x, (int)p.z)).toList();
                Polyline lineMarker = new Polyline(id, pl3xPoints);
                lineMarker.setOptions(new Options.Builder().popupContent("<div>" + label + "</div>" + detail).tooltipContent(label).strokeColor(Integer.valueOf(color.getRGB())).strokeWeight(Integer.valueOf(width)).build());
                this.layers.get((Object)markerSet).markers.add((Marker<?>)lineMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addCircleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x, double y, double z, double radius) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Circle circleMarker = new Circle(id, x, z, radius);
                circleMarker.setOptions(new Options.Builder().popupContent("<div>" + label + "</div>" + detail).tooltipContent(label).strokeColor(Integer.valueOf(lineColor.getRGB())).strokeWeight(Integer.valueOf(lineWidth)).fillColor(Integer.valueOf(fillColor.getRGB())).build());
                this.layers.get((Object)markerSet).markers.add((Marker<?>)circleMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addRectangleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x1, double z1, double x2, double z2) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Rectangle rectMarker = new Rectangle(id, x1, z1, x2, z2);
                rectMarker.setOptions(new Options.Builder().popupContent("<div>" + label + "</div>" + detail).tooltipContent(label).strokeColor(Integer.valueOf(lineColor.getRGB())).strokeWeight(Integer.valueOf(lineWidth)).fillColor(Integer.valueOf(fillColor.getRGB())).build());
                this.layers.get((Object)markerSet).markers.add((Marker<?>)rectMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addAreaMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                List<Point> pl3xPoints = points.stream().map(p -> new Point((int)p.x, (int)p.z)).toList();
                Polyline line = new Polyline(id, pl3xPoints);
                Polygon polygonMarker = new Polygon(id, line);
                polygonMarker.setOptions(new Options.Builder().popupContent("<div>" + label + "</div>" + detail).tooltipContent(label).strokeColor(Integer.valueOf(lineColor.getRGB())).strokeWeight(Integer.valueOf(lineWidth)).fillColor(Integer.valueOf(fillColor.getRGB())).build());
                this.layers.get((Object)markerSet).markers.add((Marker<?>)polygonMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarker(String markerSet, String id) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                this.layers.get((Object)markerSet).markers.removeIf(m -> m.getKey().equals(id));
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    public static class CCLayer
    extends SimpleLayer {
        public ArrayList<Marker<?>> markers = new ArrayList();
        public final World mapWorld;

        public CCLayer(String key, String label, World world) {
            super(key, () -> label);
            this.mapWorld = world;
        }

        @NotNull
        public Collection<Marker<?>> getMarkers() {
            return new LinkedList(this.markers);
        }
    }
}

