/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.integration;

import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.jonko0493.computercartographer.ComputerCartographer;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.IntegrationHelper;
import org.apache.commons.io.FilenameUtils;
import org.joml.Vector3d;
import xyz.jpenilla.squaremap.api.Key;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.api.Pair;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.SimpleLayerProvider;
import xyz.jpenilla.squaremap.api.Squaremap;
import xyz.jpenilla.squaremap.api.SquaremapProvider;
import xyz.jpenilla.squaremap.api.marker.Circle;
import xyz.jpenilla.squaremap.api.marker.Icon;
import xyz.jpenilla.squaremap.api.marker.Marker;
import xyz.jpenilla.squaremap.api.marker.MarkerOptions;
import xyz.jpenilla.squaremap.api.marker.Polygon;
import xyz.jpenilla.squaremap.api.marker.Polyline;
import xyz.jpenilla.squaremap.api.marker.Rectangle;

public class SquaremapIntegration
implements IMapIntegration {
    private final String name = "squaremap";
    private Squaremap api;
    private boolean enabled = false;
    private MapWorld currentMap;
    private Map<String, SimpleLayerProvider> layers = new HashMap<String, SimpleLayerProvider>();

    @Override
    public boolean init() {
        try {
            this.api = SquaremapProvider.get();
            this.enabled = true;
        }
        catch (Exception e) {
            ComputerCartographer.log("Squaremap is not loaded.");
            this.enabled = false;
        }
        return this.enabled;
    }

    @Override
    public String getName() {
        return "squaremap";
    }

    @Override
    public String[] getAvailableMaps() {
        if (this.enabled) {
            try {
                return (String[])this.api.mapWorlds().stream().map(m -> m.identifier().asString()).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public String getCurrentMap() {
        if (this.enabled) {
            try {
                return this.currentMap.identifier().asString();
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean setCurrentMap(String world) {
        if (this.enabled) {
            try {
                if (Arrays.asList(this.getAvailableMaps()).contains(world)) {
                    this.api.mapWorlds().stream().filter(m -> m.identifier().asString().equals(world)).findFirst().ifPresent(map -> {
                        this.currentMap = map;
                    });
                    return this.currentMap.identifier().asString().equals(world);
                }
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addMarkerSet(String setName, String label) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                SimpleLayerProvider provider = SimpleLayerProvider.builder((String)label).showControls(true).defaultHidden(false).layerPriority(5).zIndex(250).build();
                Key setNameKey = Key.of((String)setName);
                this.currentMap.layerRegistry().register(setNameKey, (Object)provider);
                this.layers.put((String)setName, provider);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.currentMap.layerRegistry().unregister(Key.of((String)setName));
                this.layers.remove(setName);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public String[] getMarkerSets() {
        if (this.enabled) {
            try {
                return (String[])this.layers.keySet().stream().map(k -> k.substring(3)).toArray(String[]::new);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return null;
    }

    @Override
    public boolean clearMarkerSet(String setName) {
        if (this.enabled) {
            try {
                setName = "cc_" + (String)setName;
                this.layers.get(setName).clearMarkers();
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addPOIMarker(String markerSet, String id, String label, String detail, String icon, double x, double y, double z) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Object realIcon = "";
                if (!icon.isEmpty()) {
                    URL iconUrl = null;
                    if (icon.startsWith("http")) {
                        iconUrl = new URL(icon);
                        realIcon = "cc_" + FilenameUtils.removeExtension((String)FilenameUtils.getBaseName((String)iconUrl.getFile().toLowerCase()));
                    }
                    String iconCompare = realIcon;
                    ArrayList<String> iconNames = new ArrayList<String>();
                    for (Pair iconRegister : this.api.iconRegistry().entries()) {
                        iconNames.add(((Key)iconRegister.left()).getKey());
                    }
                    if (iconNames.stream().noneMatch(i -> i.equals(iconCompare))) {
                        if (iconUrl != null) {
                            this.api.iconRegistry().register(Key.of((String)realIcon), (Object)Objects.requireNonNull(IntegrationHelper.downloadAndResizeIconBufferedImage(iconUrl)));
                        } else {
                            realIcon = this.api.iconRegistry().hasEntry(Key.of((String)icon)) ? icon : (this.api.iconRegistry().hasEntry(Key.of((String)("cc_" + icon))) ? "cc_" + icon : "");
                        }
                    }
                }
                Icon poiMarker = Marker.icon((Point)Point.point((double)x, (double)z), (Key)Key.of((String)realIcon), (int)24, (int)24);
                this.layers.get(markerSet).addMarker(Key.of((String)id), (Marker)poiMarker);
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addLineMarker(String markerSet, String id, String label, String detail, Color color, int width, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                List<Point> squarePoints = points.stream().map(p -> Point.point((double)p.x, (double)p.z)).toList();
                Polyline lineMarker = Polyline.polyline(squarePoints);
                lineMarker.markerOptions(MarkerOptions.builder().clickTooltip("<div>" + label + "</div>" + detail).stroke(true).strokeColor(color).strokeWeight(width).build());
                this.layers.get(markerSet).addMarker(Key.of((String)id), (Marker)lineMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addCircleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x, double y, double z, double radius) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Circle circleMarker = Circle.circle((Point)Point.point((double)x, (double)z), (double)radius);
                circleMarker.markerOptions(MarkerOptions.builder().clickTooltip("<div>" + label + "</div>" + detail).stroke(true).strokeColor(lineColor).strokeWeight(lineWidth).fill(true).fillColor(fillColor).build());
                this.layers.get(markerSet).addMarker(Key.of((String)id), (Marker)circleMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addRectangleMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, double x1, double z1, double x2, double z2) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                Rectangle rectangleMarker = Rectangle.rectangle((Point)Point.point((double)x1, (double)z1), (Point)Point.point((double)x2, (double)z2));
                rectangleMarker.markerOptions(MarkerOptions.builder().clickTooltip("<div>" + label + "</div>" + detail).stroke(true).strokeColor(lineColor).strokeWeight(lineWidth).fill(true).fillColor(fillColor).build());
                this.layers.get(markerSet).addMarker(Key.of((String)id), (Marker)rectangleMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean addAreaMarker(String markerSet, String id, String label, String detail, Color lineColor, Color fillColor, int lineWidth, ArrayList<Vector3d> points) {
        if (this.enabled) {
            try {
                markerSet = "cc_" + (String)markerSet;
                List<Point> squarePoints = points.stream().map(p -> Point.point((double)p.x, (double)p.z)).toList();
                Polygon areaMarker = Polygon.polygon(squarePoints);
                areaMarker.markerOptions(MarkerOptions.builder().clickTooltip("<div>" + label + "</div>" + detail).stroke(true).strokeColor(lineColor).strokeWeight(lineWidth).fill(true).fillColor(fillColor).build());
                this.layers.get(markerSet).addMarker(Key.of((String)id), (Marker)areaMarker);
                return true;
            }
            catch (Exception e) {
                ComputerCartographer.logException(e);
            }
        }
        return false;
    }

    @Override
    public boolean removeMarker(String markerSet, String id) {
        this.layers.get(markerSet).removeMarker(Key.of((String)id));
        return false;
    }
}

