/*
 * Decompiled with CFR 0.152.
 */
package net.jonko0493.computercartographer.peripheral;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import java.awt.Color;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import net.jonko0493.computercartographer.ComputerCartographer;
import net.jonko0493.computercartographer.block.ComputerizedCartographerBlockEntity;
import net.jonko0493.computercartographer.integration.IMapIntegration;
import net.jonko0493.computercartographer.integration.IntegrationHelper;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class ComputerizedCartographerPeripheral
implements IPeripheral {
    private final ComputerizedCartographerBlockEntity blockEntity;
    @Nullable
    private IMapIntegration currentIntegration;

    public ComputerizedCartographerPeripheral(ComputerizedCartographerBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public String getType() {
        return "cartographer";
    }

    public boolean equals(@Nullable IPeripheral other) {
        return this == other;
    }

    public void attach(IComputerAccess computer) {
        if (ComputerCartographer.integrations.isEmpty()) {
            ComputerCartographer.initIntegrations();
        }
        if (ComputerCartographer.integrations.size() == 1) {
            this.currentIntegration = ComputerCartographer.integrations.get(0);
        }
    }

    @LuaFunction
    public final String[] getAvailableIntegrations() {
        return (String[])ComputerCartographer.integrations.stream().map(IMapIntegration::getName).toArray(String[]::new);
    }

    @LuaFunction
    public final String getCurrentIntegration() {
        return this.currentIntegration == null ? null : this.currentIntegration.getName();
    }

    @LuaFunction
    public final void refreshIntegrations() {
        ComputerCartographer.initIntegrations();
        if (!ComputerCartographer.integrations.contains(this.currentIntegration)) {
            this.currentIntegration = null;
        }
        if (ComputerCartographer.integrations.size() == 1) {
            this.currentIntegration = ComputerCartographer.integrations.get(0);
        }
    }

    @LuaFunction
    public final boolean setCurrentIntegration(String integrationName) {
        AtomicBoolean success = new AtomicBoolean(false);
        ComputerCartographer.integrations.stream().filter(i -> i.getName().equalsIgnoreCase(integrationName)).findFirst().ifPresent(integration -> {
            String currentWorld = "";
            if (this.currentIntegration != null) {
                currentWorld = this.currentIntegration.getCurrentMap();
            }
            this.currentIntegration = integration;
            success.set(true);
            if (!currentWorld.isEmpty()) {
                integration.setCurrentMap(currentWorld);
            }
        });
        return success.get();
    }

    @LuaFunction
    public final String[] getAvailableMaps() {
        if (this.currentIntegration == null) {
            return null;
        }
        return this.currentIntegration.getAvailableMaps();
    }

    @LuaFunction
    public final String getCurrentMap() {
        if (this.currentIntegration == null) {
            return null;
        }
        return this.currentIntegration.getCurrentMap();
    }

    @LuaFunction
    public final boolean setCurrentMap(String world) {
        if (this.currentIntegration == null) {
            return false;
        }
        return this.currentIntegration.setCurrentMap(world);
    }

    @LuaFunction
    public final boolean addMarkerSet(String setName, String label) {
        if (this.currentIntegration == null) {
            return false;
        }
        return this.currentIntegration.addMarkerSet(setName, label);
    }

    @LuaFunction
    public final boolean removeMarkerSet(String setName) {
        if (this.currentIntegration == null) {
            return false;
        }
        return this.currentIntegration.removeMarkerSet(setName);
    }

    @LuaFunction
    public final String[] getMarkerSets() {
        if (this.currentIntegration == null) {
            return null;
        }
        return this.currentIntegration.getMarkerSets();
    }

    @LuaFunction
    public final boolean clearMarkerSet(String setName) {
        if (this.currentIntegration == null) {
            return false;
        }
        return this.currentIntegration.clearMarkerSet(setName);
    }

    @LuaFunction
    public final boolean addPOIMarker(IArguments arguments) {
        if (this.currentIntegration == null) {
            return false;
        }
        try {
            String markerSet = arguments.getString(0);
            String markerId = arguments.getString(1);
            String label = IntegrationHelper.sanitizeHtml(arguments.getString(2));
            String detail = IntegrationHelper.sanitizeHtml(arguments.getString(3));
            double x = arguments.getDouble(4);
            double y = arguments.getDouble(5);
            double z = arguments.getDouble(6);
            String icon = arguments.optString(7, "");
            return this.currentIntegration.addPOIMarker(markerSet, markerId, label, detail, icon, x, y, z);
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
            return false;
        }
    }

    @LuaFunction
    public final boolean removeMarker(String markerSet, String markerId) {
        if (this.currentIntegration == null) {
            return false;
        }
        return this.currentIntegration.removeMarker(markerSet, markerId);
    }

    @LuaFunction
    public final boolean addLineMarker(IArguments arguments) {
        if (this.currentIntegration == null) {
            return false;
        }
        try {
            String markerSet = arguments.getString(0);
            String markerId = arguments.getString(1);
            String label = IntegrationHelper.sanitizeHtml(arguments.getString(2));
            String detail = IntegrationHelper.sanitizeHtml(arguments.getString(3));
            Color color = Color.decode(arguments.getString(4));
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(arguments.getDouble(5) * 255.0));
            int width = arguments.getInt(6);
            ArrayList<Vector3d> points = IntegrationHelper.parsePoints(arguments.getTable(7));
            return this.currentIntegration.addLineMarker(markerSet, markerId, label, detail, color, width, points);
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
            return false;
        }
    }

    @LuaFunction
    public final boolean addCircleMarker(String markerSet, String markerId, String label, String detail, String lineColorStr, double lineAlpha, String fillColorStr, double fillAlpha, int lineWidth, double x, double y, double z, double radius) {
        if (this.currentIntegration == null) {
            return false;
        }
        Color lineColor = Color.decode(lineColorStr);
        lineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), (int)(lineAlpha * 255.0));
        Color fillColor = Color.decode(fillColorStr);
        fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), (int)(fillAlpha * 255.0));
        return this.currentIntegration.addCircleMarker(markerSet, markerId, IntegrationHelper.sanitizeHtml(label), IntegrationHelper.sanitizeHtml(detail), lineColor, fillColor, lineWidth, x, y, z, radius);
    }

    @LuaFunction
    public final boolean addRectangleMarker(String markerSet, String markerId, String label, String detail, String lineColorStr, double lineAlpha, String fillColorStr, double fillAlpha, int lineWidth, double x1, double z1, double x2, double z2) {
        if (this.currentIntegration == null) {
            return false;
        }
        Color lineColor = Color.decode(lineColorStr);
        lineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), (int)(lineAlpha * 255.0));
        Color fillColor = Color.decode(fillColorStr);
        fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), (int)(fillAlpha * 255.0));
        return this.currentIntegration.addRectangleMarker(markerSet, markerId, IntegrationHelper.sanitizeHtml(label), IntegrationHelper.sanitizeHtml(detail), lineColor, fillColor, lineWidth, x1, z1, x2, z2);
    }

    @LuaFunction
    public final boolean addAreaMarker(IArguments arguments) {
        if (this.currentIntegration == null) {
            return false;
        }
        try {
            String markerSet = arguments.getString(0);
            String markerId = arguments.getString(1);
            String label = IntegrationHelper.sanitizeHtml(arguments.getString(2));
            String detail = IntegrationHelper.sanitizeHtml(arguments.getString(3));
            Color lineColor = Color.decode(arguments.getString(4));
            lineColor = new Color(lineColor.getRed(), lineColor.getGreen(), lineColor.getBlue(), (int)(arguments.getDouble(5) * 255.0));
            Color fillColor = Color.decode(arguments.getString(6));
            fillColor = new Color(fillColor.getRed(), fillColor.getGreen(), fillColor.getBlue(), (int)(arguments.getDouble(7) * 255.0));
            int lineWidth = arguments.getInt(8);
            ArrayList<Vector3d> points = IntegrationHelper.parsePoints(arguments.getTable(9));
            return this.currentIntegration.addAreaMarker(markerSet, markerId, label, detail, lineColor, fillColor, lineWidth, points);
        }
        catch (Exception e) {
            ComputerCartographer.logException(e);
            return false;
        }
    }
}

