/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.mobs;

import com.github.L_Ender.cataclysm.entity.AnimationMonster.The_Watcher_Entity;
import com.github.L_Ender.cataclysm.init.ModParticle;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.effect.MagicMobEffect;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericFollowOwnerGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.UUID;
import javax.annotation.Nullable;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSEntityRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.CSPotionEffectRegistry;
import net.acetheeldritchking.cataclysm_spellbooks.registries.SpellRegistries;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;

public class SummonedCounterspellWatcher
extends The_Watcher_Entity
implements MagicSummon {
    protected LivingEntity cachedSummoner;
    protected UUID summonerUUID;

    public SummonedCounterspellWatcher(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 0;
    }

    public SummonedCounterspellWatcher(Level level, LivingEntity owner) {
        this((EntityType)CSEntityRegistry.SUMMONED_COUNTERSPELL_WATCHER.get(), level);
        this.setSummoner(owner);
    }

    protected void m_8099_() {
        this.f_21345_.m_148105_().removeIf(goal -> goal.m_26015_() instanceof HurtByTargetGoal || goal.m_26015_() instanceof NearestAttackableTargetGoal);
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true));
        this.f_21345_.m_25352_(3, (Goal)new GenericFollowOwnerGoal((PathfinderMob)this, this::getSummoner, 1.0, 10.0f, 2.0f, false, 50.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f, 1.0f));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 9.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, true));
        this.f_21346_.m_25352_(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.f_21346_.m_25352_(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.f_21346_.m_25352_(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        super.m_8099_();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        if (this.shouldIgnoreDamage(source)) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof AntiMagicSusceptible) {
            AntiMagicSusceptible antiMagicSusceptible = (AntiMagicSusceptible)pEntity;
            if (antiMagicSusceptible instanceof MagicSummon) {
                MagicSummon summon = (MagicSummon)antiMagicSusceptible;
                if (summon.getSummoner() == pEntity) {
                    antiMagicSusceptible.onAntiMagic(MagicData.getPlayerMagicData((LivingEntity)((LivingEntity)pEntity)));
                } else {
                    antiMagicSusceptible.onAntiMagic(MagicData.getPlayerMagicData((LivingEntity)((LivingEntity)pEntity)));
                }
            } else {
                antiMagicSusceptible.onAntiMagic(MagicData.getPlayerMagicData((LivingEntity)((LivingEntity)pEntity)));
            }
        } else if (pEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)pEntity;
            Utils.serverSideCancelCast((ServerPlayer)player, (boolean)true);
            MagicData.getPlayerMagicData((LivingEntity)player).getPlayerRecasts().removeAll(RecastResult.COUNTERSPELL);
        } else if (pEntity instanceof IMagicEntity) {
            IMagicEntity abstractSpellCastingMob = (IMagicEntity)pEntity;
            abstractSpellCastingMob.cancelCast();
        }
        if (pEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)pEntity;
            for (MobEffect mobEffect : livingEntity.m_21221_().keySet().stream().toList()) {
                if (!(mobEffect instanceof MagicMobEffect)) continue;
                MagicMobEffect magicMobEffect = (MagicMobEffect)mobEffect;
                livingEntity.m_21195_((MobEffect)magicMobEffect);
            }
        }
        Explosion explosion = new Explosion(this.m_9236_(), null, (DamageSource)((AbstractSpell)SpellRegistries.DOS_SWARM.get()).getDamageSource((Entity)this, (Entity)this.getSummoner()), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, false, Explosion.BlockInteraction.KEEP);
        if (!ForgeEventFactory.onExplosionStart((Level)this.m_9236_(), (Explosion)explosion)) {
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
        this.m_6074_();
        return Utils.doMeleeAttack((Mob)this, (Entity)pEntity, (DamageSource)((AbstractSpell)SpellRegistries.DOS_SWARM.get()).getDamageSource((Entity)this, (Entity)this.getSummoner()));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_() && this.f_19797_ % 20 == 0) {
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123777_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)1, (double)0.1, (double)0.2, (double)0.1, (double)0.01, (boolean)true);
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123755_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)5, (double)0.1, (double)0.4, (double)0.1, (double)0.01, (boolean)true);
            MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)ParticleTypes.f_123744_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)15, (double)0.4, (double)0.8, (double)0.4, (double)0.04, (boolean)true);
        }
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.m_9236_(), (LivingEntity)this.cachedSummoner, (UUID)this.summonerUUID);
    }

    public void setSummoner(@Nullable LivingEntity owner) {
        if (owner != null) {
            this.summonerUUID = owner.m_20148_();
            this.cachedSummoner = owner;
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        this.onDeathHelper();
        super.m_6667_(pDamageSource);
    }

    public void onRemovedFromWorld() {
        this.onRemovedHelper((Entity)this, (SummonTimer)CSPotionEffectRegistry.WATCHER_TIMER.get());
        super.onRemovedFromWorld();
    }

    public void onUnSummon() {
        if (!this.m_9236_().f_46443_) {
            this.spawnParticles((LivingEntity)this);
            this.m_146870_();
        }
    }

    private void spawnParticles(LivingEntity entity) {
        ServerLevel level = (ServerLevel)entity.m_9236_();
        level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticle.EM_PULSE.get()), entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (entityIn == this.getSummoner() || this.isAlliedHelper(entityIn)) {
            return true;
        }
        if (this.getSummoner() != null && !entityIn.m_7307_((Entity)this.getSummoner())) {
            return false;
        }
        return this.m_5647_() == null && entityIn.m_5647_() == null;
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.summonerUUID = OwnerHelper.deserializeOwner((CompoundTag)pCompound);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        OwnerHelper.serializeOwner((CompoundTag)pCompound, (UUID)this.summonerUUID);
    }
}

