/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.entity.render.armor;

import mod.azure.azurelib.core.animatable.model.CoreGeoBone;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRenderer;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererConfig;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipeline;
import mod.azure.azurelib.rewrite.render.armor.AzArmorRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneContext;
import mod.azure.azurelib.rewrite.render.armor.bone.AzArmorBoneProvider;
import mod.azure.azurelib.rewrite.render.layer.AzAutoGlowingLayer;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class CursiumMageArmorRenderer
extends AzArmorRenderer {
    private static final ResourceLocation GEO = new ResourceLocation("cataclysm_spellbooks", "geo/cursium_mage.geo.json");
    private static final ResourceLocation TEX = new ResourceLocation("cataclysm_spellbooks", "textures/models/armor/cursium_mage_armor.png");

    public CursiumMageArmorRenderer() {
        super((AzRendererConfig)AzArmorRendererConfig.builder((ResourceLocation)GEO, (ResourceLocation)TEX).addRenderLayer((AzRenderLayer)new AzAutoGlowingLayer()).build());
    }

    protected AzArmorRendererPipeline createPipeline(AzRendererConfig config) {
        return new AzArmorRendererPipeline(config, this){

            protected AzRendererPipelineContext<ItemStack> createContext(AzRendererPipeline<ItemStack> rendererPipeline) {
                return new AzArmorRendererPipelineContext(rendererPipeline){

                    public AzArmorBoneContext boneContext() {
                        return new AzArmorBoneContext(){
                            protected AzBone armorLeggingTorsoBone;

                            public AzBone getArmorLeggingTorsoBone(AzBakedModel model) {
                                return model.getBone("armorLeggingTorsoLayer").orElse(null);
                            }

                            public void grabRelevantBones(AzBakedModel model, AzArmorBoneProvider boneProvider) {
                                super.grabRelevantBones(model, boneProvider);
                                this.armorLeggingTorsoBone = this.getArmorLeggingTorsoBone(model);
                            }

                            public void applyBoneVisibilityBySlot(EquipmentSlot currentSlot) {
                                this.setAllVisible(false);
                                this.setBoneVisible(this.armorLeggingTorsoBone, false);
                                switch (currentSlot) {
                                    case HEAD: {
                                        this.setBoneVisible(this.head, true);
                                        break;
                                    }
                                    case CHEST: {
                                        this.setBoneVisible(this.body, true);
                                        this.setBoneVisible(this.rightArm, true);
                                        this.setBoneVisible(this.leftArm, true);
                                        break;
                                    }
                                    case LEGS: {
                                        this.setBoneVisible(this.armorLeggingTorsoBone, true);
                                        this.setBoneVisible(this.rightLeg, true);
                                        this.setBoneVisible(this.leftLeg, true);
                                        break;
                                    }
                                    case FEET: {
                                        this.setBoneVisible(this.rightBoot, true);
                                        this.setBoneVisible(this.leftBoot, true);
                                        break;
                                    }
                                }
                            }

                            public void applyBaseTransformations(HumanoidModel<?> baseModel) {
                                super.applyBaseTransformations(baseModel);
                                if (this.armorLeggingTorsoBone != null) {
                                    ModelPart modelPart = baseModel.f_102810_;
                                    RenderUtils.matchModelPartRot((ModelPart)modelPart, (CoreGeoBone)this.armorLeggingTorsoBone);
                                    this.armorLeggingTorsoBone.updatePosition(modelPart.f_104200_, -modelPart.f_104201_, modelPart.f_104202_);
                                }
                            }
                        };
                    }
                };
            }
        };
    }
}

