/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Abyss_Fireball_Entity;
import com.github.L_Ender.cataclysm.entity.projectile.Ignis_Fireball_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import java.util.List;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

@AutoSpellConfig
public class AbyssFireballSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "abyss_fireball");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(8).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237115_((String)"ui.cataclysm_spellbooks.fireball_details"), Component.m_237110_((String)"ui.cataclysm_spellbooks.recast_count", (Object[])new Object[]{Utils.stringTruncation((double)this.recastCount(spellLevel), (int)2)}));
    }

    public AbyssFireballSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 100;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public int getRecastCount(int spellLevel, @Nullable LivingEntity entity) {
        return this.recastCount(spellLevel);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        if (!playerMagicData.getPlayerRecasts().hasRecastForSpell(this.getSpellId())) {
            playerMagicData.getPlayerRecasts().addRecast(new RecastInstance(this.getSpellId(), spellLevel, this.getRecastCount(spellLevel, entity), 100, castSource, null), playerMagicData);
        }
        float MAX_HEALTH = entity.m_21233_();
        float baseHealth = entity.m_21223_();
        double percent = baseHealth / MAX_HEALTH * 100.0f;
        if (percent <= 30.0) {
            this.shootAbyssFireball(entity, level);
        } else if (percent <= 50.0) {
            this.shootFireball(entity, level, true);
        } else {
            this.shootFireball(entity, level, false);
        }
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public void onRecastFinished(ServerPlayer serverPlayer, RecastInstance recastInstance, RecastResult recastResult, ICastDataSerializable castDataSerializable) {
        if (recastResult == RecastResult.USED_ALL_RECASTS) {
            Level level = serverPlayer.m_9236_();
            this.shootAbyssFireball((LivingEntity)serverPlayer, level);
        }
        super.onRecastFinished(serverPlayer, recastInstance, recastResult, castDataSerializable);
    }

    private void shootAbyssFireball(LivingEntity caster, Level level) {
        Ignis_Abyss_Fireball_Entity fireball = new Ignis_Abyss_Fireball_Entity(level, caster);
        fireball.m_146884_(caster.m_20182_().m_82520_(0.0, (double)caster.m_20192_() - fireball.m_20191_().m_82376_() * 0.5, 0.0));
        fireball.m_37251_((Entity)caster, caster.m_146909_(), caster.m_6080_(), 0.0f, 1.0f, 1.0f);
        level.m_7967_((Entity)fireball);
    }

    private void shootFireball(LivingEntity caster, Level level, boolean soul) {
        Ignis_Fireball_Entity fireball = new Ignis_Fireball_Entity(level, caster);
        fireball.m_146884_(caster.m_20182_().m_82520_(0.0, (double)caster.m_20192_() - fireball.m_20191_().m_82376_() * 0.5, 0.0));
        fireball.m_37251_((Entity)caster, caster.m_146909_(), caster.m_6080_(), 0.0f, 1.0f, 1.0f);
        fireball.setSoul(soul);
        level.m_7967_((Entity)fireball);
    }

    private int recastCount(int count) {
        return count;
    }
}

