/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.cataclysm_spellbooks.spells.fire;

import com.github.L_Ender.cataclysm.init.ModItems;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.damage.SpellDamageSource;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.acetheeldritchking.cataclysm_spellbooks.entity.spells.infernal_blade.InfernalBladeProjectile;
import net.acetheeldritchking.cataclysm_spellbooks.spells.fire.AbstractIgnisSpell;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class InfernalStrikeSpell
extends AbstractIgnisSpell {
    private final ResourceLocation spellId = new ResourceLocation("cataclysm_spellbooks", "infernal_strike");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(8).setCooldownSeconds(20.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.cataclsym_spellboks.incinerator_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getBonusDamage(spellLevel, caster), (int)2)}));
    }

    public InfernalStrikeSpell() {
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 2;
        this.castTime = 0;
        this.baseManaCost = 110;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.FLAMING_STRIKE_SWING.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float bonusDamage;
        InfernalBladeProjectile infernalBlade = new InfernalBladeProjectile(level, entity);
        infernalBlade.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - infernalBlade.m_20191_().m_82376_() * 0.5, 0.0));
        infernalBlade.m_37251_((Entity)entity, entity.m_146909_(), entity.m_6080_(), 0.0f, 1.0f, 1.0f);
        Item incinerator = (Item)ModItems.THE_INCINERATOR.get();
        float MAX_HEALTH = entity.m_21233_();
        float baseHealth = entity.m_21223_();
        double percent = baseHealth / MAX_HEALTH * 100.0f;
        float damage = infernalBlade.getIsSoul() ? this.getDamage(spellLevel, entity) * 1.5f : this.getDamage(spellLevel, entity);
        float f = bonusDamage = infernalBlade.getIsSoul() ? this.getBonusDamage(spellLevel, entity) * 1.5f : this.getBonusDamage(spellLevel, entity);
        if (entity.m_21205_().m_150930_(incinerator)) {
            infernalBlade.setDamage(bonusDamage);
        } else {
            infernalBlade.setDamage(damage);
        }
        if (percent <= 50.0) {
            infernalBlade.setIsSoul(true);
        } else {
            infernalBlade.setIsSoul(false);
        }
        level.m_7967_((Entity)infernalBlade);
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public SpellDamageSource getDamageSource(Entity projectile, Entity attacker) {
        return super.getDamageSource(projectile, attacker);
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 1.5f;
    }

    private float getBonusDamage(int spellLevel, LivingEntity caster) {
        float baseDamage = this.getDamage(spellLevel, caster);
        int bonusAmount = (int)(1.5 + (double)spellLevel);
        return baseDamage + (float)bonusAmount;
    }
}

